/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.ServerBlobAuditingPolicyInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ServerBlobAuditingPoliciesInner {
    private ServerBlobAuditingPoliciesService service;
    private SqlManagementClientImpl client;

    public ServerBlobAuditingPoliciesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ServerBlobAuditingPoliciesService)retrofit.create(ServerBlobAuditingPoliciesService.class);
        this.client = client;
    }

    public ServerBlobAuditingPolicyInner get(String resourceGroupName, String serverName) {
        return (ServerBlobAuditingPolicyInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body();
    }

    public ServiceFuture<ServerBlobAuditingPolicyInner> getAsync(String resourceGroupName, String serverName, ServiceCallback<ServerBlobAuditingPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<ServerBlobAuditingPolicyInner> getAsync(String resourceGroupName, String serverName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<ServerBlobAuditingPolicyInner>, ServerBlobAuditingPolicyInner>(){

            public ServerBlobAuditingPolicyInner call(ServiceResponse<ServerBlobAuditingPolicyInner> response) {
                return (ServerBlobAuditingPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServerBlobAuditingPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String blobAuditingPolicyName = "default";
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerBlobAuditingPolicyInner>>>(){

            public Observable<ServiceResponse<ServerBlobAuditingPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerBlobAuditingPoliciesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerBlobAuditingPolicyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerBlobAuditingPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerBlobAuditingPolicyInner createOrUpdate(String resourceGroupName, String serverName, ServerBlobAuditingPolicyInner parameters) {
        return (ServerBlobAuditingPolicyInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<ServerBlobAuditingPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerBlobAuditingPolicyInner parameters, ServiceCallback<ServerBlobAuditingPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<ServerBlobAuditingPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerBlobAuditingPolicyInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<ServerBlobAuditingPolicyInner>, ServerBlobAuditingPolicyInner>(){

            public ServerBlobAuditingPolicyInner call(ServiceResponse<ServerBlobAuditingPolicyInner> response) {
                return (ServerBlobAuditingPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServerBlobAuditingPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, ServerBlobAuditingPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String blobAuditingPolicyName = "default";
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, "default", this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServerBlobAuditingPolicyInner>(){}.getType());
    }

    public ServerBlobAuditingPolicyInner beginCreateOrUpdate(String resourceGroupName, String serverName, ServerBlobAuditingPolicyInner parameters) {
        return (ServerBlobAuditingPolicyInner)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ServerBlobAuditingPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, ServerBlobAuditingPolicyInner parameters, ServiceCallback<ServerBlobAuditingPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<ServerBlobAuditingPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, ServerBlobAuditingPolicyInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<ServerBlobAuditingPolicyInner>, ServerBlobAuditingPolicyInner>(){

            public ServerBlobAuditingPolicyInner call(ServiceResponse<ServerBlobAuditingPolicyInner> response) {
                return (ServerBlobAuditingPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServerBlobAuditingPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, ServerBlobAuditingPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String blobAuditingPolicyName = "default";
        String apiVersion = "2017-03-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, "default", this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerBlobAuditingPolicyInner>>>(){

            public Observable<ServiceResponse<ServerBlobAuditingPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerBlobAuditingPoliciesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerBlobAuditingPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerBlobAuditingPolicyInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServerBlobAuditingPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerBlobAuditingPolicies get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/auditingSettings/{blobAuditingPolicyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="blobAuditingPolicyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerBlobAuditingPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/auditingSettings/{blobAuditingPolicyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="blobAuditingPolicyName") String var3, @Path(value="subscriptionId") String var4, @Body ServerBlobAuditingPolicyInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerBlobAuditingPolicies beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/auditingSettings/{blobAuditingPolicyName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="blobAuditingPolicyName") String var3, @Path(value="subscriptionId") String var4, @Body ServerBlobAuditingPolicyInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

