/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.sql.SqlFirewallRule;
import com.microsoft.azure.management.sql.SqlFirewallRules;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.SqlFirewallRulesImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.List;
import rx.Completable;

@LangDefinition
class FirewallRulesImpl
implements SqlServer.FirewallRules {
    private final String resourceGroupName;
    private final String sqlServerName;
    private final SqlFirewallRules.SqlFirewallRulesCreatable sqlFirewallRules;

    FirewallRulesImpl(SqlServerManager manager, String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlFirewallRules = new SqlFirewallRulesImpl(((SqlManagementClientImpl)((Object)manager.inner())).servers(), manager);
    }

    @Override
    public SqlFirewallRule get(String firewallRuleName) {
        return this.sqlFirewallRules.getBySqlServer(this.resourceGroupName, this.sqlServerName, firewallRuleName);
    }

    @Override
    public SqlFirewallRule.DefinitionStages.Blank define(String firewallRuleName) {
        return this.sqlFirewallRules.definedWithSqlServer(this.resourceGroupName, this.sqlServerName, firewallRuleName);
    }

    @Override
    public List<SqlFirewallRule> list() {
        return this.sqlFirewallRules.listBySqlServer(this.resourceGroupName, this.sqlServerName);
    }

    @Override
    public void delete(String firewallRuleName) {
        this.sqlFirewallRules.deleteByParent(this.resourceGroupName, this.sqlServerName, firewallRuleName);
    }

    @Override
    public Completable deleteAsync(String firewallRuleName) {
        return this.sqlFirewallRules.deleteByParentAsync(this.resourceGroupName, this.sqlServerName, firewallRuleName);
    }

    protected SqlFirewallRules sqlFirewallRules() {
        return this.sqlFirewallRules;
    }
}

