/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Represents the properties of a recommended Azure SQL Database being
 * upgraded.
 */
public class RecommendedDatabaseProperties {
    /**
     * The name of the Azure SQL database being upgraded.
     */
    @JsonProperty(value = "Name")
    private String name;

    /**
     * The target edition for the Azure SQL database being upgraded. Possible
     * values include: 'Basic', 'Standard', 'Premium', 'Free', 'Stretch',
     * 'DataWarehouse'.
     */
    @JsonProperty(value = "TargetEdition")
    private TargetDatabaseEditions targetEdition;

    /**
     * The target Service Level Objective for the Azure SQL database being
     * upgraded.
     */
    @JsonProperty(value = "TargetServiceLevelObjective")
    private String targetServiceLevelObjective;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the RecommendedDatabaseProperties object itself.
     */
    public RecommendedDatabaseProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the targetEdition value.
     *
     * @return the targetEdition value
     */
    public TargetDatabaseEditions targetEdition() {
        return this.targetEdition;
    }

    /**
     * Set the targetEdition value.
     *
     * @param targetEdition the targetEdition value to set
     * @return the RecommendedDatabaseProperties object itself.
     */
    public RecommendedDatabaseProperties withTargetEdition(TargetDatabaseEditions targetEdition) {
        this.targetEdition = targetEdition;
        return this;
    }

    /**
     * Get the targetServiceLevelObjective value.
     *
     * @return the targetServiceLevelObjective value
     */
    public String targetServiceLevelObjective() {
        return this.targetServiceLevelObjective;
    }

    /**
     * Set the targetServiceLevelObjective value.
     *
     * @param targetServiceLevelObjective the targetServiceLevelObjective value to set
     * @return the RecommendedDatabaseProperties object itself.
     */
    public RecommendedDatabaseProperties withTargetServiceLevelObjective(String targetServiceLevelObjective) {
        this.targetServiceLevelObjective = targetServiceLevelObjective;
        return this;
    }

}
