/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.ServerAutomaticTuningInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ServerAutomaticTuningsInner {
    private ServerAutomaticTuningsService service;
    private SqlManagementClientImpl client;

    public ServerAutomaticTuningsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ServerAutomaticTuningsService)retrofit.create(ServerAutomaticTuningsService.class);
        this.client = client;
    }

    public ServerAutomaticTuningInner get(String resourceGroupName, String serverName) {
        return (ServerAutomaticTuningInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body();
    }

    public ServiceFuture<ServerAutomaticTuningInner> getAsync(String resourceGroupName, String serverName, ServiceCallback<ServerAutomaticTuningInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<ServerAutomaticTuningInner> getAsync(String resourceGroupName, String serverName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<ServerAutomaticTuningInner>, ServerAutomaticTuningInner>(){

            public ServerAutomaticTuningInner call(ServiceResponse<ServerAutomaticTuningInner> response) {
                return (ServerAutomaticTuningInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServerAutomaticTuningInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerAutomaticTuningInner>>>(){

            public Observable<ServiceResponse<ServerAutomaticTuningInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerAutomaticTuningsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerAutomaticTuningInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerAutomaticTuningInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerAutomaticTuningInner update(String resourceGroupName, String serverName, ServerAutomaticTuningInner parameters) {
        return (ServerAutomaticTuningInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ServerAutomaticTuningInner> updateAsync(String resourceGroupName, String serverName, ServerAutomaticTuningInner parameters, ServiceCallback<ServerAutomaticTuningInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<ServerAutomaticTuningInner> updateAsync(String resourceGroupName, String serverName, ServerAutomaticTuningInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<ServerAutomaticTuningInner>, ServerAutomaticTuningInner>(){

            public ServerAutomaticTuningInner call(ServiceResponse<ServerAutomaticTuningInner> response) {
                return (ServerAutomaticTuningInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServerAutomaticTuningInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, ServerAutomaticTuningInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-03-01-preview";
        return this.service.update(resourceGroupName, serverName, this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerAutomaticTuningInner>>>(){

            public Observable<ServiceResponse<ServerAutomaticTuningInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerAutomaticTuningsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerAutomaticTuningInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerAutomaticTuningInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServerAutomaticTuningsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerAutomaticTunings get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/automaticTuning/current")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerAutomaticTunings update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/automaticTuning/current")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Body ServerAutomaticTuningInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

