/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerinstance.CachedImages;
import com.microsoft.azure.management.containerinstance.Capabilities;
import com.microsoft.azure.management.containerinstance.ContainerGroup;
import com.microsoft.azure.management.containerinstance.ContainerGroups;
import com.microsoft.azure.management.containerinstance.Operation;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupImpl;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupsInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManager;
import com.microsoft.azure.management.containerinstance.implementation.LogsInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class ContainerGroupsImpl
extends TopLevelModifiableResourcesImpl<ContainerGroup, ContainerGroupImpl, ContainerGroupInner, ContainerGroupsInner, ContainerInstanceManager>
implements ContainerGroups {
    private final StorageManager storageManager;
    private final GraphRbacManager rbacManager;

    protected ContainerGroupsImpl(ContainerInstanceManager manager, StorageManager storageManager, GraphRbacManager rbacManager) {
        super((InnerSupportsListing)((ContainerInstanceManagementClientImpl)((Object)manager.inner())).containerGroups(), (ManagerBase)manager);
        this.storageManager = storageManager;
        this.rbacManager = rbacManager;
    }

    protected ContainerGroupImpl wrapModel(String name) {
        return new ContainerGroupImpl(name, new ContainerGroupInner(), (ContainerInstanceManager)this.manager(), this.storageManager, this.rbacManager);
    }

    protected ContainerGroupImpl wrapModel(ContainerGroupInner inner) {
        if (inner == null) {
            return null;
        }
        return new ContainerGroupImpl(inner.name(), inner, (ContainerInstanceManager)this.manager(), this.storageManager, this.rbacManager);
    }

    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerGroups().deleteAsync(resourceGroupName, name).toCompletable();
    }

    public ContainerGroup.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public String getLogContent(String resourceGroupName, String containerGroupName, String containerName) {
        LogsInner logsInner = ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containers().listLogs(resourceGroupName, containerGroupName, containerName);
        return logsInner != null ? logsInner.content() : null;
    }

    @Override
    public String getLogContent(String resourceGroupName, String containerGroupName, String containerName, int tailLineCount) {
        LogsInner logsInner = ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containers().listLogs(resourceGroupName, containerGroupName, containerName, tailLineCount, null);
        return logsInner != null ? logsInner.content() : null;
    }

    @Override
    public Observable<String> getLogContentAsync(String resourceGroupName, String containerGroupName, String containerName) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containers().listLogsAsync(resourceGroupName, containerGroupName, containerName).map((Func1)new Func1<LogsInner, String>(){

            public String call(LogsInner logsInner) {
                return logsInner.content();
            }
        });
    }

    @Override
    public Observable<String> getLogContentAsync(String resourceGroupName, String containerGroupName, String containerName, int tailLineCount) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containers().listLogsAsync(resourceGroupName, containerGroupName, containerName, tailLineCount, null).map((Func1)new Func1<LogsInner, String>(){

            public String call(LogsInner logsInner) {
                return logsInner.content();
            }
        });
    }

    @Override
    public PagedList<Operation> listOperations() {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).operations().list();
    }

    @Override
    public Observable<Operation> listOperationsAsync() {
        return ContainerGroupsImpl.convertPageToInnerAsync(((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).operations().listAsync());
    }

    @Override
    public PagedList<CachedImages> listCachedImages(String location) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).locations().listCachedImages(location);
    }

    @Override
    public Observable<CachedImages> listCachedImagesAsync(String location) {
        return ContainerGroupsImpl.convertPageToInnerAsync(((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).locations().listCachedImagesAsync(location));
    }

    @Override
    public PagedList<Capabilities> listCapabilities(String location) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).locations().listCapabilities(location);
    }

    @Override
    public Observable<Capabilities> listCapabilitiesAsync(String location) {
        return ContainerGroupsImpl.convertPageToInnerAsync(((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).locations().listCapabilitiesAsync(location));
    }

    @Override
    public void start(String resourceGroupName, String containerGroupName) {
        ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerGroups().start(resourceGroupName, containerGroupName);
    }

    @Override
    public Completable startAsync(String resourceGroupName, String containerGroupName) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerGroups().startAsync(resourceGroupName, containerGroupName).toCompletable();
    }

    public Observable<ContainerGroup> listAsync() {
        return this.wrapPageAsync(((ContainerGroupsInner)this.inner()).listAsync()).flatMap((Func1)new Func1<ContainerGroup, Observable<ContainerGroup>>(){

            public Observable<ContainerGroup> call(ContainerGroup containerGroup) {
                return containerGroup.refreshAsync();
            }
        });
    }

    public Observable<ContainerGroup> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((ContainerGroupsInner)this.inner()).listByResourceGroupAsync(resourceGroupName)).flatMap((Func1)new Func1<ContainerGroup, Observable<ContainerGroup>>(){

            public Observable<ContainerGroup> call(ContainerGroup containerGroup) {
                return containerGroup.refreshAsync();
            }
        });
    }

    public final PagedList<ContainerGroup> list() {
        PagedListConverter<ContainerGroupInner, ContainerGroup> converter = new PagedListConverter<ContainerGroupInner, ContainerGroup>(){

            public Observable<ContainerGroup> typeConvertAsync(ContainerGroupInner inner) {
                return ContainerGroupsImpl.this.wrapModel(inner).refreshAsync();
            }
        };
        return converter.convert(((ContainerGroupsInner)this.inner()).list());
    }

    public PagedList<ContainerGroup> listByResourceGroup(String resourceGroupName) {
        PagedListConverter<ContainerGroupInner, ContainerGroup> converter = new PagedListConverter<ContainerGroupInner, ContainerGroup>(){

            public Observable<ContainerGroup> typeConvertAsync(ContainerGroupInner inner) {
                return ContainerGroupsImpl.this.wrapModel(inner).refreshAsync();
            }
        };
        return converter.convert(((ContainerGroupsInner)this.inner()).listByResourceGroup(resourceGroupName));
    }
}

