/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ServiceAssociationLinksInner {
    private ServiceAssociationLinksService service;
    private ContainerInstanceManagementClientImpl client;

    public ServiceAssociationLinksInner(Retrofit retrofit, ContainerInstanceManagementClientImpl client) {
        this.service = (ServiceAssociationLinksService)retrofit.create(ServiceAssociationLinksService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String virtualNetworkName, String subnetName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualNetworkName, String subnetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, virtualNetworkName, subnetName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceAssociationLinksInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServiceAssociationLinksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ServiceAssociationLinks delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}/providers/Microsoft.ContainerInstance/serviceAssociationLinks/default", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualNetworkName") String var3, @Path(value="subnetName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

