/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupsInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerLogsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class ContainerInstanceManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private ContainerGroupsInner containerGroups;
    private ContainerLogsInner containerLogs;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ContainerInstanceManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public ContainerInstanceManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public ContainerInstanceManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public ContainerInstanceManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public ContainerGroupsInner containerGroups() {
        return this.containerGroups;
    }

    public ContainerLogsInner containerLogs() {
        return this.containerLogs;
    }

    public ContainerInstanceManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public ContainerInstanceManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public ContainerInstanceManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2017-08-01-preview";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.containerGroups = new ContainerGroupsInner(this.restClient().retrofit(), this);
        this.containerLogs = new ContainerLogsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "ContainerInstanceManagementClient", "2017-08-01-preview");
    }
}

