/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The volume.
 */
public class Volume {
    /**
     * The volume name.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The Azure file volume.
     */
    @JsonProperty(value = "azureFile", required = true)
    private AzureFileVolume azureFile;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the Volume object itself.
     */
    public Volume withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the azureFile value.
     *
     * @return the azureFile value
     */
    public AzureFileVolume azureFile() {
        return this.azureFile;
    }

    /**
     * Set the azureFile value.
     *
     * @param azureFile the azureFile value to set
     * @return the Volume object itself.
     */
    public Volume withAzureFile(AzureFileVolume azureFile) {
        this.azureFile = azureFile;
        return this;
    }

}
