/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The instance view of the container. Only valid in response.
 */
public class ContainerPropertiesInstanceView {
    /**
     * The number of times that the container has been restarted.
     */
    @JsonProperty(value = "restartCount")
    private Integer restartCount;

    /**
     * Current container state.
     */
    @JsonProperty(value = "currentState")
    private ContainerState currentState;

    /**
     * Previous container state.
     */
    @JsonProperty(value = "previousState")
    private ContainerState previousState;

    /**
     * The events of this container instance.
     */
    @JsonProperty(value = "events")
    private List<ContainerEvent> events;

    /**
     * Get the restartCount value.
     *
     * @return the restartCount value
     */
    public Integer restartCount() {
        return this.restartCount;
    }

    /**
     * Set the restartCount value.
     *
     * @param restartCount the restartCount value to set
     * @return the ContainerPropertiesInstanceView object itself.
     */
    public ContainerPropertiesInstanceView withRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return this;
    }

    /**
     * Get the currentState value.
     *
     * @return the currentState value
     */
    public ContainerState currentState() {
        return this.currentState;
    }

    /**
     * Set the currentState value.
     *
     * @param currentState the currentState value to set
     * @return the ContainerPropertiesInstanceView object itself.
     */
    public ContainerPropertiesInstanceView withCurrentState(ContainerState currentState) {
        this.currentState = currentState;
        return this;
    }

    /**
     * Get the previousState value.
     *
     * @return the previousState value
     */
    public ContainerState previousState() {
        return this.previousState;
    }

    /**
     * Set the previousState value.
     *
     * @param previousState the previousState value to set
     * @return the ContainerPropertiesInstanceView object itself.
     */
    public ContainerPropertiesInstanceView withPreviousState(ContainerState previousState) {
        this.previousState = previousState;
        return this;
    }

    /**
     * Get the events value.
     *
     * @return the events value
     */
    public List<ContainerEvent> events() {
        return this.events;
    }

    /**
     * Set the events value.
     *
     * @param events the events value to set
     * @return the ContainerPropertiesInstanceView object itself.
     */
    public ContainerPropertiesInstanceView withEvents(List<ContainerEvent> events) {
        this.events = events;
        return this;
    }

}
