/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A container event.
 */
public class ContainerEvent {
    /**
     * The count of the event.
     */
    @JsonProperty(value = "count")
    private Integer count;

    /**
     * Date/time of the first event.
     */
    @JsonProperty(value = "firstTimestamp")
    private DateTime firstTimestamp;

    /**
     * Date/time of the last event.
     */
    @JsonProperty(value = "lastTimestamp")
    private DateTime lastTimestamp;

    /**
     * The event message.
     */
    @JsonProperty(value = "message")
    private String message;

    /**
     * The event type.
     */
    @JsonProperty(value = "type")
    private String type;

    /**
     * Get the count value.
     *
     * @return the count value
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count value.
     *
     * @param count the count value to set
     * @return the ContainerEvent object itself.
     */
    public ContainerEvent withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Get the firstTimestamp value.
     *
     * @return the firstTimestamp value
     */
    public DateTime firstTimestamp() {
        return this.firstTimestamp;
    }

    /**
     * Set the firstTimestamp value.
     *
     * @param firstTimestamp the firstTimestamp value to set
     * @return the ContainerEvent object itself.
     */
    public ContainerEvent withFirstTimestamp(DateTime firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
        return this;
    }

    /**
     * Get the lastTimestamp value.
     *
     * @return the lastTimestamp value
     */
    public DateTime lastTimestamp() {
        return this.lastTimestamp;
    }

    /**
     * Set the lastTimestamp value.
     *
     * @param lastTimestamp the lastTimestamp value to set
     * @return the ContainerEvent object itself.
     */
    public ContainerEvent withLastTimestamp(DateTime lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return this;
    }

    /**
     * Get the message value.
     *
     * @return the message value
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message value.
     *
     * @param message the message value to set
     * @return the ContainerEvent object itself.
     */
    public ContainerEvent withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the type value.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type value.
     *
     * @param type the type value to set
     * @return the ContainerEvent object itself.
     */
    public ContainerEvent withType(String type) {
        this.type = type;
        return this;
    }

}
