/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The container probe, for liveness or readiness.
 */
public class ContainerProbe {
    /**
     * The execution command to probe.
     */
    @JsonProperty(value = "exec")
    private ContainerExec exec;

    /**
     * The Http Get settings to probe.
     */
    @JsonProperty(value = "httpGet")
    private ContainerHttpGet httpGet;

    /**
     * The initial delay seconds.
     */
    @JsonProperty(value = "initialDelaySeconds")
    private Integer initialDelaySeconds;

    /**
     * The period seconds.
     */
    @JsonProperty(value = "periodSeconds")
    private Integer periodSeconds;

    /**
     * The failure threshold.
     */
    @JsonProperty(value = "failureThreshold")
    private Integer failureThreshold;

    /**
     * The success threshold.
     */
    @JsonProperty(value = "successThreshold")
    private Integer successThreshold;

    /**
     * The timeout seconds.
     */
    @JsonProperty(value = "timeoutSeconds")
    private Integer timeoutSeconds;

    /**
     * Get the execution command to probe.
     *
     * @return the exec value
     */
    public ContainerExec exec() {
        return this.exec;
    }

    /**
     * Set the execution command to probe.
     *
     * @param exec the exec value to set
     * @return the ContainerProbe object itself.
     */
    public ContainerProbe withExec(ContainerExec exec) {
        this.exec = exec;
        return this;
    }

    /**
     * Get the Http Get settings to probe.
     *
     * @return the httpGet value
     */
    public ContainerHttpGet httpGet() {
        return this.httpGet;
    }

    /**
     * Set the Http Get settings to probe.
     *
     * @param httpGet the httpGet value to set
     * @return the ContainerProbe object itself.
     */
    public ContainerProbe withHttpGet(ContainerHttpGet httpGet) {
        this.httpGet = httpGet;
        return this;
    }

    /**
     * Get the initial delay seconds.
     *
     * @return the initialDelaySeconds value
     */
    public Integer initialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    /**
     * Set the initial delay seconds.
     *
     * @param initialDelaySeconds the initialDelaySeconds value to set
     * @return the ContainerProbe object itself.
     */
    public ContainerProbe withInitialDelaySeconds(Integer initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
        return this;
    }

    /**
     * Get the period seconds.
     *
     * @return the periodSeconds value
     */
    public Integer periodSeconds() {
        return this.periodSeconds;
    }

    /**
     * Set the period seconds.
     *
     * @param periodSeconds the periodSeconds value to set
     * @return the ContainerProbe object itself.
     */
    public ContainerProbe withPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
        return this;
    }

    /**
     * Get the failure threshold.
     *
     * @return the failureThreshold value
     */
    public Integer failureThreshold() {
        return this.failureThreshold;
    }

    /**
     * Set the failure threshold.
     *
     * @param failureThreshold the failureThreshold value to set
     * @return the ContainerProbe object itself.
     */
    public ContainerProbe withFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    /**
     * Get the success threshold.
     *
     * @return the successThreshold value
     */
    public Integer successThreshold() {
        return this.successThreshold;
    }

    /**
     * Set the success threshold.
     *
     * @param successThreshold the successThreshold value to set
     * @return the ContainerProbe object itself.
     */
    public ContainerProbe withSuccessThreshold(Integer successThreshold) {
        this.successThreshold = successThreshold;
        return this;
    }

    /**
     * Get the timeout seconds.
     *
     * @return the timeoutSeconds value
     */
    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    /**
     * Set the timeout seconds.
     *
     * @param timeoutSeconds the timeoutSeconds value to set
     * @return the ContainerProbe object itself.
     */
    public ContainerProbe withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

}
