/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.containerinstance.ContainerExecRequest;
import com.microsoft.azure.management.containerinstance.implementation.ContainerExecResponseInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.microsoft.azure.management.containerinstance.implementation.LogsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ContainersInner {
    private ContainersService service;
    private ContainerInstanceManagementClientImpl client;

    public ContainersInner(Retrofit retrofit, ContainerInstanceManagementClientImpl client) {
        this.service = (ContainersService)retrofit.create(ContainersService.class);
        this.client = client;
    }

    public LogsInner listLogs(String resourceGroupName, String containerGroupName, String containerName) {
        return (LogsInner)((ServiceResponse)this.listLogsWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName).toBlocking().single()).body();
    }

    public ServiceFuture<LogsInner> listLogsAsync(String resourceGroupName, String containerGroupName, String containerName, ServiceCallback<LogsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listLogsWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName), serviceCallback);
    }

    public Observable<LogsInner> listLogsAsync(String resourceGroupName, String containerGroupName, String containerName) {
        return this.listLogsWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName).map((Func1)new Func1<ServiceResponse<LogsInner>, LogsInner>(){

            public LogsInner call(ServiceResponse<LogsInner> response) {
                return (LogsInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<LogsInner>> listLogsWithServiceResponseAsync(String resourceGroupName, String containerGroupName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerGroupName == null) {
            throw new IllegalArgumentException("Parameter containerGroupName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer tail = null;
        return this.service.listLogs(this.client.subscriptionId(), resourceGroupName, containerGroupName, containerName, this.client.apiVersion(), tail, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogsInner>>>(){

            public Observable<ServiceResponse<LogsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainersInner.this.listLogsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public LogsInner listLogs(String resourceGroupName, String containerGroupName, String containerName, Integer tail) {
        return (LogsInner)((ServiceResponse)this.listLogsWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, tail).toBlocking().single()).body();
    }

    public ServiceFuture<LogsInner> listLogsAsync(String resourceGroupName, String containerGroupName, String containerName, Integer tail, ServiceCallback<LogsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listLogsWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, tail), serviceCallback);
    }

    public Observable<LogsInner> listLogsAsync(String resourceGroupName, String containerGroupName, String containerName, Integer tail) {
        return this.listLogsWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, tail).map((Func1)new Func1<ServiceResponse<LogsInner>, LogsInner>(){

            public LogsInner call(ServiceResponse<LogsInner> response) {
                return (LogsInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<LogsInner>> listLogsWithServiceResponseAsync(String resourceGroupName, String containerGroupName, String containerName, Integer tail) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerGroupName == null) {
            throw new IllegalArgumentException("Parameter containerGroupName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listLogs(this.client.subscriptionId(), resourceGroupName, containerGroupName, containerName, this.client.apiVersion(), tail, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogsInner>>>(){

            public Observable<ServiceResponse<LogsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainersInner.this.listLogsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LogsInner> listLogsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LogsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ContainerExecResponseInner executeCommand(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        return (ContainerExecResponseInner)((ServiceResponse)this.executeCommandWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).toBlocking().single()).body();
    }

    public ServiceFuture<ContainerExecResponseInner> executeCommandAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest, ServiceCallback<ContainerExecResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.executeCommandWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest), serviceCallback);
    }

    public Observable<ContainerExecResponseInner> executeCommandAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        return this.executeCommandWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).map((Func1)new Func1<ServiceResponse<ContainerExecResponseInner>, ContainerExecResponseInner>(){

            public ContainerExecResponseInner call(ServiceResponse<ContainerExecResponseInner> response) {
                return (ContainerExecResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ContainerExecResponseInner>> executeCommandWithServiceResponseAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerGroupName == null) {
            throw new IllegalArgumentException("Parameter containerGroupName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (containerExecRequest == null) {
            throw new IllegalArgumentException("Parameter containerExecRequest is required and cannot be null.");
        }
        Validator.validate((Object)containerExecRequest);
        return this.service.executeCommand(this.client.subscriptionId(), resourceGroupName, containerGroupName, containerName, this.client.apiVersion(), containerExecRequest, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerExecResponseInner>>>(){

            public Observable<ServiceResponse<ContainerExecResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainersInner.this.executeCommandDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerExecResponseInner> executeCommandDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerExecResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ContainersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.Containers listLogs"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/logs")
        public Observable<Response<ResponseBody>> listLogs(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="containerGroupName") String var3, @Path(value="containerName") String var4, @Query(value="api-version") String var5, @Query(value="tail") Integer var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.Containers executeCommand"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/exec")
        public Observable<Response<ResponseBody>> executeCommand(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="containerGroupName") String var3, @Path(value="containerName") String var4, @Query(value="api-version") String var5, @Body ContainerExecRequest var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

