/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.query.DocumentProducer;
import com.microsoft.azure.documentdb.internal.query.ExceptionHelper;
import com.microsoft.azure.documentdb.internal.query.ParallelDocumentQueryExecutionContextBase;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.documentdb.internal.query.funcs.Func1;
import com.microsoft.azure.documentdb.internal.query.orderbyquery.OrderByDocumentProducerConsumeComparator;
import com.microsoft.azure.documentdb.internal.query.orderbyquery.OrderByQueryResult;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;

public class OrderByQueryExecutionContext
extends ParallelDocumentQueryExecutionContextBase<OrderByQueryResult> {
    private static final int DEFAULT_ORDER_BY_PAGE_SIZE = 1000;
    private static final int MINIMUM_PAGE_SIZE = 5;
    private final PriorityBlockingQueue<DocumentProducer<OrderByQueryResult>> documentProducerConsumeQueue;
    private final Comparator<DocumentProducer<OrderByQueryResult>> comparer;
    private DocumentProducer<OrderByQueryResult> currentDocumentProducer;

    public static OrderByQueryExecutionContext create(DocumentQueryClientInternal client, String collectionSelfLink, SqlQuerySpec querySpec, FeedOptions options, String resourceLink, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo) {
        try {
            OrderByQueryExecutionContext context = new OrderByQueryExecutionContext(client, collectionSelfLink, querySpec, options, resourceLink, partitionedQueryExecutionInfo);
            Integer pageSizeForOrderBy = options.getPageSize() == null || options.getPageSize() < 1 ? 1000 : Math.max(options.getPageSize(), 5);
            Collection<PartitionKeyRange> ranges = context.getTargetPartitionKeyRanges(partitionedQueryExecutionInfo.getQueryRanges());
            context.initializationFuture = context.initializeAsync(partitionedQueryExecutionInfo, (int)pageSizeForOrderBy, OrderByQueryResult.class, ranges, options);
            return context;
        }
        catch (Exception e) {
            throw ExceptionHelper.toRuntimeException(ExceptionHelper.unwrap(e));
        }
    }

    private OrderByQueryExecutionContext(DocumentQueryClientInternal client, String collectionSelfLink, SqlQuerySpec querySpec, FeedOptions options, String resourceLink, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo) {
        super(client, collectionSelfLink, querySpec, options, resourceLink, partitionedQueryExecutionInfo, OrderByQueryResult.class);
        this.comparer = new OrderByDocumentProducerConsumeComparator(partitionedQueryExecutionInfo.getQueryInfo().getOrderBy());
        this.documentProducerConsumeQueue = new PriorityBlockingQueue<DocumentProducer<OrderByQueryResult>>(this.documentProducers.capacity(), this.comparer);
    }

    @Override
    protected boolean hasNextInternal() {
        return !this.isDone();
    }

    @Override
    protected Future<Void> initializeAsync(PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, int initialPageSize, Class<OrderByQueryResult> documentProducerClassT, Collection<PartitionKeyRange> ranges, FeedOptions options) throws Exception {
        super.initializeAsync(partitionedQueryExecutionInfo, initialPageSize, documentProducerClassT, ranges, options).get();
        final OrderByQueryExecutionContext that = this;
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (DocumentProducer producer : that.documentProducers) {
                    producer.tryScheduleFetch();
                }
                for (int index = 0; index < that.documentProducers.size(); ++index) {
                    DocumentProducer producer;
                    producer = (DocumentProducer)that.documentProducers.get(index);
                    if (!that.tryMoveNextProducer(producer)) continue;
                    producer = (DocumentProducer)that.documentProducers.get(index);
                    that.documentProducerConsumeQueue.put(producer);
                }
                return null;
            }
        };
        return this.executorService.submit(callable);
    }

    public boolean isDone() {
        return this.currentDocumentProducer == null && this.documentProducerConsumeQueue.size() <= 0;
    }

    private void updateCurrentDocumentProducer() {
        if (this.documentProducerConsumeQueue.size() > 0) {
            if (this.currentDocumentProducer == null) {
                this.currentDocumentProducer = this.documentProducerConsumeQueue.poll();
            } else if (this.comparer.compare(this.currentDocumentProducer, this.documentProducerConsumeQueue.peek()) > 0) {
                this.documentProducerConsumeQueue.put(this.currentDocumentProducer);
                this.currentDocumentProducer = this.documentProducerConsumeQueue.poll();
            }
        }
    }

    @Override
    public OrderByQueryResult nextInternal() throws Exception {
        OrderByQueryResult result = null;
        while (!this.isDone() && result == null) {
            OrderByQueryResult orderByResult;
            this.updateCurrentDocumentProducer();
            result = orderByResult = (OrderByQueryResult)this.currentDocumentProducer.peek();
            if (this.tryMoveNextProducer(this.currentDocumentProducer)) continue;
            this.currentDocumentProducer = null;
        }
        if (this.isDone()) {
            super.onFinish();
        }
        return result;
    }

    private boolean tryMoveNextProducer(DocumentProducer<OrderByQueryResult> producer) throws Exception {
        final OrderByQueryExecutionContext that = this;
        return super.tryMoveNextProducer(producer, new Func1<DocumentProducer<OrderByQueryResult>, DocumentProducer<OrderByQueryResult>>(){

            @Override
            public DocumentProducer<OrderByQueryResult> apply(DocumentProducer<OrderByQueryResult> currentProducer) {
                return that.repairOrderByContext(currentProducer);
            }
        });
    }

    private DocumentProducer<OrderByQueryResult> repairOrderByContext(DocumentProducer<OrderByQueryResult> parentProducer) {
        List<PartitionKeyRange> replacementRanges = super.getReplacementRanges(parentProducer.getTargetRange(), this.collectionSelfLink);
        int indexOfCurrentDocumentProducer = Collections.binarySearch(this.documentProducers, parentProducer, new Comparator<DocumentProducer<OrderByQueryResult>>(){

            @Override
            public int compare(DocumentProducer<OrderByQueryResult> producer1, DocumentProducer<OrderByQueryResult> producer2) {
                return producer1.getTargetRange().getMinInclusive().compareTo(producer2.getTargetRange().getMinInclusive());
            }
        });
        super.repairContext(this.collectionSelfLink, indexOfCurrentDocumentProducer, this.defaultComparator, replacementRanges, this.querySpec);
        return this.documentProducers.get(indexOfCurrentDocumentProducer);
    }
}

