/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.Error;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

public class ErrorUtils {
    public static void maybeThrowException(String requestUri, HttpResponse response, boolean isGatewayResponse, Logger logger) throws DocumentClientException {
        if (requestUri == null) {
            throw new IllegalArgumentException("requestUri");
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 400) {
            HttpEntity httpEntity = response.getEntity();
            String body = "";
            if (httpEntity != null) {
                try {
                    body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException | ParseException e) {
                    if (logger != null) {
                        logger.error("Failed to get content from the http response", e);
                    }
                    throw new IllegalStateException("Failed to get content from the http response", e);
                }
            }
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                responseHeaders.put(header.getName(), header.getValue());
            }
            String statusCodeString = response.getStatusLine().getReasonPhrase() != null ? response.getStatusLine().getReasonPhrase().replace(" ", "") : "";
            String subStatusCodeString = responseHeaders.containsKey("x-ms-substatus") ? (String)responseHeaders.get("x-ms-substatus") : "";
            Error error = null;
            if (isGatewayResponse) {
                error = new Error(body);
                error = new Error(statusCodeString, String.format("%s, StatusCode: %s", error.getMessage(), statusCodeString), error.getPartitionedQueryExecutionInfo());
            } else {
                error = new Error(statusCodeString, String.format("%s%nActivityId: %s, Request URI: %s, StatusCode: %s, SubStatusCode: %s", body, responseHeaders.get("x-ms-activity-id"), requestUri, statusCodeString, subStatusCodeString));
            }
            throw new DocumentClientException(statusCode, error, responseHeaders);
        }
    }
}

