/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.Utils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public final class AuthorizationHelper {
    public static String GenerateKeyAuthorizationSignature(String verb, String resourceIdOrFullName, ResourceType resourceType, Map<String, String> headers, String masterKey) {
        if (verb == null || verb.isEmpty()) {
            throw new IllegalArgumentException("verb");
        }
        if (resourceIdOrFullName == null) {
            resourceIdOrFullName = "";
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("resourceType");
        }
        if (headers == null) {
            throw new IllegalArgumentException("headers");
        }
        if (masterKey == null || masterKey.isEmpty()) {
            throw new IllegalArgumentException("masterKey");
        }
        byte[] decodedBytes = Base64.decodeBase64((byte[])masterKey.getBytes());
        SecretKeySpec signingKey = new SecretKeySpec(decodedBytes, "HMACSHA256");
        String body = String.format("%s\n%s\n%s\n", verb.toLowerCase(), AuthorizationHelper.getResourceSegement(resourceType).toLowerCase(), resourceIdOrFullName);
        if (headers.containsKey("x-ms-date")) {
            body = body + headers.get("x-ms-date").toLowerCase();
        }
        body = body + '\n';
        if (headers.containsKey("date")) {
            body = body + headers.get("date").toLowerCase();
        }
        body = body + '\n';
        Mac mac = null;
        try {
            mac = Mac.getInstance("HMACSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to get an instance of HMACSHA256.", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("Failed to initialize the Mac.", e);
        }
        byte[] digest = mac.doFinal(body.getBytes());
        String auth = Utils.encodeBase64String(digest);
        String authtoken = "type=master&ver=1.0&sig=" + auth;
        return authtoken;
    }

    public static String getAuthorizationTokenUsingResourceTokens(Map<String, String> resourceTokens, String path, String resourceId) {
        if (resourceTokens == null) {
            throw new IllegalArgumentException("resourceTokens");
        }
        String resourceToken = null;
        if (resourceTokens.containsKey(resourceId) && resourceTokens.get(resourceId) != null) {
            resourceToken = resourceTokens.get(resourceId);
        } else if (StringUtils.isEmpty((CharSequence)path) || StringUtils.isEmpty((CharSequence)resourceId)) {
            if (resourceTokens.size() > 0) {
                resourceToken = resourceTokens.values().iterator().next();
            }
        } else {
            String[] pathParts = StringUtils.split((String)path, (char)'/');
            String[] resourceTypes = new String[]{"dbs", "colls", "docs", "sprocs", "udfs", "triggers", "users", "permissions", "attachments", "media", "conflicts"};
            HashSet<String> resourceTypesSet = new HashSet<String>();
            for (String resourceType : resourceTypes) {
                resourceTypesSet.add(resourceType);
            }
            for (int i = pathParts.length - 1; i >= 0; --i) {
                if (resourceTypesSet.contains(pathParts[i]) || !resourceTokens.containsKey(pathParts[i])) continue;
                resourceToken = resourceTokens.get(pathParts[i]);
            }
        }
        return resourceToken;
    }

    private static String getResourceSegement(ResourceType resourceType) {
        switch (resourceType) {
            case Attachment: {
                return "attachments";
            }
            case Database: {
                return "dbs";
            }
            case Conflict: {
                return "conflicts";
            }
            case PartitionKeyRange: {
                return "pkranges";
            }
            case Document: {
                return "docs";
            }
            case DocumentCollection: {
                return "colls";
            }
            case Offer: {
                return "offers";
            }
            case Permission: {
                return "permissions";
            }
            case StoredProcedure: {
                return "sprocs";
            }
            case Trigger: {
                return "triggers";
            }
            case UserDefinedFunction: {
                return "udfs";
            }
            case User: {
                return "users";
            }
            case Media: {
                return "media";
            }
            case DatabaseAccount: {
                return "";
            }
        }
        return null;
    }
}

