/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.QueryIterable;
import com.microsoft.azure.documentdb.Resource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class FeedResponse<T extends Resource> {
    private QueryIterable<T> inner;
    private Map<String, Long> usageHeaders;
    private Map<String, Long> quotaHeaders;
    private boolean useEtagAsContinuation;

    FeedResponse(QueryIterable<T> result) {
        this(result, false);
    }

    FeedResponse(QueryIterable<T> result, boolean useEtagAsContinuation) {
        this.inner = result;
        this.usageHeaders = new HashMap<String, Long>();
        this.quotaHeaders = new HashMap<String, Long>();
        this.useEtagAsContinuation = useEtagAsContinuation;
    }

    private static String getValueOrNull(Map<String, String> map, String key) {
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public long getDatabaseQuota() {
        return this.getMaxQuotaHeader("databases");
    }

    public long getDatabaseUsage() {
        return this.getCurrentQuotaHeader("databases");
    }

    public long getCollectionQuota() {
        return this.getMaxQuotaHeader("collections");
    }

    public long getCollectionUsage() {
        return this.getCurrentQuotaHeader("collections");
    }

    public long getUserQuota() {
        return this.getMaxQuotaHeader("users");
    }

    public long getUserUsage() {
        return this.getCurrentQuotaHeader("users");
    }

    public long getPermissionQuota() {
        return this.getMaxQuotaHeader("permissions");
    }

    public long getPermissionUsage() {
        return this.getCurrentQuotaHeader("permissions");
    }

    public long getCollectionSizeQuota() {
        return this.getMaxQuotaHeader("collectionSize");
    }

    public long getCollectionSizeUsage() {
        return this.getCurrentQuotaHeader("collectionSize");
    }

    public long getStoredProceduresQuota() {
        return this.getMaxQuotaHeader("storedProcedures");
    }

    public long getStoredProceduresUsage() {
        return this.getCurrentQuotaHeader("storedProcedures");
    }

    public long getTriggersQuota() {
        return this.getMaxQuotaHeader("triggers");
    }

    public long getTriggersUsage() {
        return this.getCurrentQuotaHeader("triggers");
    }

    public long getUserDefinedFunctionsQuota() {
        return this.getMaxQuotaHeader("functions");
    }

    public long getUserDefinedFunctionsUsage() {
        return this.getCurrentQuotaHeader("functions");
    }

    public String getMaxResourceQuota() {
        return FeedResponse.getValueOrNull(this.inner.getResponseHeaders(), "x-ms-resource-quota");
    }

    public String getCurrentResourceQuotaUsage() {
        return FeedResponse.getValueOrNull(this.inner.getResponseHeaders(), "x-ms-resource-usage");
    }

    public double getRequestCharge() {
        String value = FeedResponse.getValueOrNull(this.inner.getResponseHeaders(), "x-ms-request-charge");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0.0;
        }
        return Double.valueOf(value);
    }

    public boolean getRUPerMinuteUsed() {
        String value = this.getResponseHeaders().get("x-ms-documentdb-is-ru-per-minute-used");
        return !StringUtils.isEmpty((CharSequence)value) && !"0".equals(value) && !"false".equals(value.toLowerCase());
    }

    public String getActivityId() {
        return FeedResponse.getValueOrNull(this.inner.getResponseHeaders(), "x-ms-activity-id");
    }

    public String getResponseContinuation() {
        String headerName = this.useEtagAsContinuation ? "etag" : "x-ms-continuation";
        return FeedResponse.getValueOrNull(this.inner.getResponseHeaders(), headerName);
    }

    public String getSessionToken() {
        return FeedResponse.getValueOrNull(this.inner.getResponseHeaders(), "x-ms-session-token");
    }

    public Map<String, String> getResponseHeaders() {
        return this.inner.getResponseHeaders();
    }

    public QueryIterable<T> getQueryIterable() {
        return this.inner;
    }

    public Iterator<T> getQueryIterator() {
        return this.inner.iterator();
    }

    private long getCurrentQuotaHeader(String headerName) {
        if (this.usageHeaders.size() == 0 && !this.getMaxResourceQuota().isEmpty() && !this.getCurrentResourceQuotaUsage().isEmpty()) {
            this.populateQuotaHeader(this.getMaxResourceQuota(), this.getCurrentResourceQuotaUsage());
        }
        if (this.usageHeaders.containsKey(headerName)) {
            return this.usageHeaders.get(headerName);
        }
        return 0L;
    }

    private long getMaxQuotaHeader(String headerName) {
        if (this.quotaHeaders.size() == 0 && !this.getMaxResourceQuota().isEmpty() && !this.getCurrentResourceQuotaUsage().isEmpty()) {
            this.populateQuotaHeader(this.getMaxResourceQuota(), this.getCurrentResourceQuotaUsage());
        }
        if (this.quotaHeaders.containsKey(headerName)) {
            return this.quotaHeaders.get(headerName);
        }
        return 0L;
    }

    private void populateQuotaHeader(String headerMaxQuota, String headerCurrentUsage) {
        String[] headerMaxQuotaWords = StringUtils.split((String)headerMaxQuota, (String)"=|;", (int)-1);
        String[] headerCurrentUsageWords = StringUtils.split((String)headerCurrentUsage, (String)"=|;", (int)-1);
        for (int i = 0; i < headerMaxQuotaWords.length; ++i) {
            if (headerMaxQuotaWords[i].equalsIgnoreCase("databases")) {
                this.quotaHeaders.put("databases", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("databases", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("collections")) {
                this.quotaHeaders.put("collections", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("collections", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("users")) {
                this.quotaHeaders.put("users", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("users", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("permissions")) {
                this.quotaHeaders.put("permissions", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("permissions", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("collectionSize")) {
                this.quotaHeaders.put("collectionSize", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("collectionSize", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("storedProcedures")) {
                this.quotaHeaders.put("storedProcedures", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("storedProcedures", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("triggers")) {
                this.quotaHeaders.put("triggers", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("triggers", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (!headerMaxQuotaWords[i].equalsIgnoreCase("functions")) continue;
            this.quotaHeaders.put("functions", Long.valueOf(headerMaxQuotaWords[i + 1]));
            this.usageHeaders.put("functions", Long.valueOf(headerCurrentUsageWords[i + 1]));
        }
    }
}

