/*
 * The MIT License (MIT)
 * Copyright (c) 2017 Microsoft Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.microsoft.azure.documentdb.internal.query;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.SqlQuerySpec;

public class PeekingParallelDocumentQueryExecutionContext implements QueryExecutionContext<Document> {

    private Document buffered;
    protected ParallelDocumentQueryExecutionContext context;

    public static PeekingParallelDocumentQueryExecutionContext create(DocumentQueryClientInternal client,
            String collectionSelfLink, SqlQuerySpec querySpec, FeedOptions options, String resourceLink,
            PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, int initialPageSize) {

        PeekingParallelDocumentQueryExecutionContext context = new PeekingParallelDocumentQueryExecutionContext(
                ParallelDocumentQueryExecutionContext.create(client, collectionSelfLink, querySpec, options, resourceLink,
                        partitionedQueryExecutionInfo, initialPageSize));
        return context;

    }

    private PeekingParallelDocumentQueryExecutionContext(ParallelDocumentQueryExecutionContext context) {
        this.context = context;
    }

    private boolean moveNext() {

        try {
            this.buffered = context.next();
            return true;
        } catch (NoSuchElementException e) {
            this.buffered = null;
            return false;
        }
    }

    /* (non-Javadoc)
     * @see java.util.Iterator#hasNext()
     */
    @Override
    public boolean hasNext() {
        if (this.buffered != null) {
            return true;
        } else {
            return moveNext();
        }
    }

    /* (non-Javadoc)
     * @see java.util.Iterator#next()
     */
    @Override
    public Document next() {
        if (this.buffered != null) {
            Document res = this.buffered;
            this.moveNext();
            return res;
        } else {
            throw new NoSuchElementException();
        }
    }

    /* (non-Javadoc)
     * @see com.microsoft.azure.documentdb.internal.query.QueryExecutionContext#getResponseHeaders()
     */
    @Override
    public Map<String, String> getResponseHeaders() {
        return context.getResponseHeaders();
    }

    /* (non-Javadoc)
     * @see com.microsoft.azure.documentdb.internal.query.QueryExecutionContext#fetchNextBlock()
     */
    @Override
    public List<Document> fetchNextBlock() throws DocumentClientException {
        return context.fetchNextBlock();
    }

    /* (non-Javadoc)
     * @see com.microsoft.azure.documentdb.internal.query.QueryExecutionContext#onNotifyStop()
     */
    @Override
    public void onNotifyStop() {
        this.context.onNotifyStop();
    }
}
