/* 
 * Copyright (c) Microsoft Corporation.  All rights reserved.
 */

package com.microsoft.azure.documentdb.internal;

/**
 * Resource types in the Azure Cosmos DB database service.
 */
public enum ResourceType {
    Attachment,
    Conflict,
    Database,
    DatabaseAccount,
    Document,
    DocumentCollection,
    Media,  // Media doesn't have a corresponding resource class.
    Offer,
    PartitionKeyRange,
    Permission,
    StoredProcedure,
    Trigger,
    User,
    UserDefinedFunction,
    MasterPartition,
    ServerPartition,
    Topology,
    Schema;

    public boolean isScript() {
        return this == ResourceType.UserDefinedFunction
                || this == ResourceType.Trigger
                || this == ResourceType.StoredProcedure;
    }

    public boolean isPartitioned() {
        return this == ResourceType.Document ||
                this == ResourceType.Attachment ||
                this == ResourceType.Conflict ||
                this == ResourceType.Schema;
    }

    public boolean isMasterResource() {
        return this == ResourceType.Offer ||
                this == ResourceType.Database ||
                this == ResourceType.User ||
                this == ResourceType.Permission ||
                this == ResourceType.Topology ||
                this == ResourceType.PartitionKeyRange ||
                this == ResourceType.DocumentCollection;
    }

    /**
     * @return
     */
    public boolean isCollectionChild() {
        return this == ResourceType.Document ||
                this == ResourceType.Attachment ||
                this == ResourceType.Conflict ||
                this == ResourceType.Schema ||
                this.isScript();
    }
}
