package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;

/**
 * Define a delegate used by the RetryUtility to refresh auth token on retry.
 *
 */
public interface RefreshAuthTokenDelegate {
	/**
	 * Update the new auth token on DocumentServiceRequest
	 * @throws DocumentClientException the original exception
	 */
	void apply(DocumentServiceRequest request);
}
