package com.microsoft.azure.documentdb.internal;

import java.util.Map;

/**
 * Represents types that can provide functionality to generate authorization token for the Azure Cosmos DB database
 * service.
 */
public interface AuthorizationTokenProvider {
    String generateKeyAuthorizationSignature(String verb,
                                             String resourceIdOrFullName,
                                             ResourceType resourceType,
                                             Map<String, String> headers);

    String getAuthorizationTokenUsingResourceTokens(String path,
                                                    String resourceId);
    
    String getMasterKey();
    
    Map<String, String> getResourceTokens();
}
