package com.microsoft.azure.documentdb;

import java.util.ArrayList;
import java.util.Collection;

import org.json.JSONObject;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.documentdb.internal.Constants;

public class PartitionKeyRangeStatistics extends JsonSerializable {
    
    @JsonProperty(Constants.Properties.PARTITION_KEYS)
    private Collection<PartitionKeyStatistics> partitionKeyStatistics;

    /**
     * Initialize a PartitionKeyRangeStatistics object using the input JSON string.
     *
     * @param jsonString the json string that represents the Partition Key Statistics for the physical partition.
     */
    public PartitionKeyRangeStatistics(String jsonString) {
        super(jsonString);
    }

    /**
     * Constructor.
     *
     * @param jsonObject the json object that represents the Partition Key Statistics for the physical partition.
     */
    public PartitionKeyRangeStatistics(JSONObject jsonObject) {
        super(jsonObject);
    }

    /**
     * Gets the partitionKeyRangeId property.
     *
     * @return the value of the partition key range id.
     */
    public String getId() {
        return super.getString(Constants.Properties.ID);
    }

    /**
     * Gets the sizeInKB property.
     *
     * @return the size (in KB) of the partition.
     */
    public long getSizeInKB() {
        return super.getLong(Constants.Properties.SIZE_IN_KB);
    }

    /**
     * Gets the documentCount property.
     *
     * @return the count of documents in the partition.
     */
    public long getDocumentCount() {
        return super.getLong(Constants.Properties.DOCUMENT_COUNT);
    }
    
    /**
     * Gets the partitionKeyStatistics property.
     *
     * @return the size (in KB) of the top logical partition keys within each physical partition of the collection.
     */
    public Collection<PartitionKeyStatistics> getPartitionKeyStatistics() {
        if(super.getCollection(Constants.Properties.PARTITION_KEYS) != null) {
            return super.getCollection(Constants.Properties.PARTITION_KEYS, PartitionKeyStatistics.class);
        }

        return new ArrayList<PartitionKeyStatistics>();
    }

    @Override
    void populatePropertyBag() {
        if(this.partitionKeyStatistics != null) {
            for (PartitionKeyStatistics partitionKeyStatistic : this.partitionKeyStatistics) {
                partitionKeyStatistic.populatePropertyBag();
            }
        }
    }    
}
