package com.microsoft.azure.documentdb;

/**
 * Specifies the common options associated with feed methods (enumeration operations) in the Azure Cosmos DB database service.
 */
public abstract class FeedOptionsBase {
    private Integer pageSize;
    private String requestContinuation;

    protected FeedOptionsBase() {}

    FeedOptionsBase(FeedOptionsBase options) {
        this.pageSize = options.pageSize;
        this.requestContinuation = options.requestContinuation;
    }

    /**
     * Gets the maximum number of items to be returned in the enumeration
     * operation.
     *
     * @return the page size.
     */
    public Integer getPageSize() {
        return this.pageSize;
    }

    /**
     * Sets the maximum number of items to be returned in the enumeration
     * operation.
     *
     * @param pageSize
     *            the page size.
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * Gets the request continuation token.
     *
     * @return the request continuation.
     */
    public String getRequestContinuation() {
        return this.requestContinuation;
    }

    /**
     * Sets the request continuation token.
     *
     * @param requestContinuation
     *            the request continuation.
     */
    public void setRequestContinuation(String requestContinuation) {
        this.requestContinuation = requestContinuation;
    }
}
