/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.serializer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.microsoft.azure.CloudError;
import java.io.IOException;

final class CloudErrorDeserializer
extends JsonDeserializer<CloudError> {
    private ObjectMapper mapper;

    private CloudErrorDeserializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    static SimpleModule getModule(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(CloudError.class, (JsonDeserializer)new CloudErrorDeserializer(mapper));
        return module;
    }

    public CloudError deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode errorNode = (JsonNode)p.readValueAsTree();
        if (errorNode == null) {
            return null;
        }
        if (errorNode.get("error") != null) {
            errorNode = errorNode.get("error");
        }
        String nodeContent = errorNode.toString();
        nodeContent = nodeContent.replaceFirst("(?i)\"code\"", "\"code\"").replaceFirst("(?i)\"message\"", "\"message\"").replaceFirst("(?i)\"target\"", "\"target\"").replaceFirst("(?i)\"details\"", "\"details\"");
        JsonParser parser = new JsonFactory().createParser(nodeContent);
        parser.setCodec((ObjectCodec)this.mapper);
        return (CloudError)parser.readValueAs(CloudError.class);
    }
}

