/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.azure.management.apigeneration.Beta;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Beta
final class AzureCliToken
implements Cloneable {
    @JsonProperty(value="_authority")
    private String authority;
    @JsonProperty(value="_clientId")
    private String clientId;
    private String tokenType;
    private long expiresIn;
    private String expiresOn;
    private Date expiresOnDate;
    private String oid;
    private String userId;
    private String servicePrincipalId;
    private String servicePrincipalTenant;
    private boolean isMRRT;
    private String resource;
    private String accessToken;
    private String refreshToken;
    private String identityProvider;

    AzureCliToken() {
    }

    boolean isServicePrincipal() {
        return this.servicePrincipalId != null;
    }

    String tenant() {
        if (this.isServicePrincipal()) {
            return this.servicePrincipalTenant;
        }
        String[] parts = this.authority.split("/");
        return parts[parts.length - 1];
    }

    String clientId() {
        if (this.isServicePrincipal()) {
            return this.servicePrincipalId;
        }
        return this.clientId;
    }

    String authority() {
        return this.authority;
    }

    boolean expired() {
        return this.expiresOn != null && this.expiresOn().before(new Date());
    }

    String accessToken() {
        return this.accessToken;
    }

    Date expiresOn() {
        if (this.expiresOnDate == null) {
            try {
                this.expiresOnDate = DateTime.parse((String)this.expiresOn, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSS")).toDate();
            }
            catch (IllegalArgumentException e) {
                this.expiresOnDate = DateTime.parse((String)this.expiresOn).toDate();
            }
        }
        return this.expiresOnDate;
    }

    AzureCliToken withAuthenticationResult(AuthenticationResult result) {
        this.accessToken = result.getAccessToken();
        this.refreshToken = result.getRefreshToken();
        this.expiresIn = result.getExpiresAfter();
        this.expiresOnDate = result.getExpiresOnDate();
        return this;
    }

    AzureCliToken withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    String refreshToken() {
        return this.refreshToken;
    }

    AzureCliToken withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    String user() {
        if (this.isServicePrincipal()) {
            return this.servicePrincipalId;
        }
        return this.userId;
    }

    boolean isMRRT() {
        return this.isMRRT;
    }

    String resource() {
        return this.resource;
    }

    AzureCliToken withResource(String resource) {
        this.resource = resource;
        return this;
    }

    public AzureCliToken clone() throws CloneNotSupportedException {
        AzureCliToken token = (AzureCliToken)super.clone();
        token.expiresOnDate = (Date)this.expiresOn().clone();
        return token;
    }
}

