/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.credentials.RefreshTokenClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class UserTokenCredentials
extends AzureTokenCredentials {
    private Map<String, AuthenticationResult> tokens;
    private String clientId;
    private String username;
    private String password;
    private RefreshTokenClient refreshTokenClient;

    public UserTokenCredentials(String clientId, String domain, String username, String password, AzureEnvironment environment) {
        super(environment, domain);
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.tokens = new ConcurrentHashMap<String, AuthenticationResult>();
        this.refreshTokenClient = new RefreshTokenClient(environment.activeDirectoryEndpoint(), this.proxy());
    }

    public String clientId() {
        return this.clientId;
    }

    public String username() {
        return this.username;
    }

    public synchronized String getToken(String resource) throws IOException {
        boolean shouldRefresh;
        AuthenticationResult authenticationResult = this.tokens.get(resource);
        if (authenticationResult != null && authenticationResult.getExpiresOnDate().after(new Date())) {
            return authenticationResult.getAccessToken();
        }
        boolean bl = shouldRefresh = authenticationResult != null;
        if (authenticationResult == null && !this.tokens.isEmpty()) {
            authenticationResult = new ArrayList<AuthenticationResult>(this.tokens.values()).get(0);
            shouldRefresh = authenticationResult.isMultipleResourceRefreshToken();
        }
        if (shouldRefresh) {
            authenticationResult = this.acquireAccessTokenFromRefreshToken(resource, authenticationResult.getRefreshToken(), authenticationResult.isMultipleResourceRefreshToken());
        }
        if (authenticationResult == null) {
            authenticationResult = this.acquireNewAccessToken(resource);
        }
        this.tokens.put(resource, authenticationResult);
        return authenticationResult.getAccessToken();
    }

    AuthenticationResult acquireNewAccessToken(String resource) throws IOException {
        String authorityUrl = this.environment().activeDirectoryEndpoint() + this.domain();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AuthenticationContext context = new AuthenticationContext(authorityUrl, false, executor);
        if (this.proxy() != null) {
            context.setProxy(this.proxy());
        }
        try {
            AuthenticationResult authenticationResult = (AuthenticationResult)context.acquireToken(resource, this.clientId(), this.username(), this.password, null).get();
            return authenticationResult;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuthenticationResult acquireAccessTokenFromRefreshToken(String resource, String refreshToken, boolean isMultipleResourceRefreshToken) throws IOException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            AuthenticationResult authenticationResult = this.refreshTokenClient.refreshToken(this.domain(), this.clientId(), resource, refreshToken, isMultipleResourceRefreshToken);
            return authenticationResult;
        }
        catch (Exception e) {
            AuthenticationResult authenticationResult = null;
            return authenticationResult;
        }
        finally {
            executor.shutdown();
        }
    }
}

