/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.credentials.AzureCliToken;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.credentials.UserTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Beta
final class AzureCliSubscription {
    private String environmentName;
    private String id;
    private String name;
    private String tenantId;
    private String state;
    private UserInfo user;
    private String clientId;
    private boolean isDefault;
    private AzureTokenCredentials credentialInstance;
    private Map<String, AzureCliToken> userTokens = new ConcurrentHashMap<String, AzureCliToken>();
    private AzureCliToken servicePrincipalToken;

    AzureCliSubscription() {
    }

    String id() {
        return this.id;
    }

    boolean isDefault() {
        return this.isDefault;
    }

    String clientId() {
        return this.clientId;
    }

    AzureCliSubscription withToken(AzureCliToken token) {
        if (this.isServicePrincipal()) {
            this.servicePrincipalToken = token;
        } else {
            if (token.resource() != null) {
                this.userTokens.put(token.resource(), token);
            }
            if (this.clientId == null) {
                this.clientId = token.clientId();
            }
        }
        return this;
    }

    AzureEnvironment environment() {
        if (this.environmentName == null) {
            return null;
        }
        if (this.environmentName.equalsIgnoreCase("AzureCloud")) {
            return AzureEnvironment.AZURE;
        }
        if (this.environmentName.equalsIgnoreCase("AzureChinaCloud")) {
            return AzureEnvironment.AZURE_CHINA;
        }
        if (this.environmentName.equalsIgnoreCase("AzureGermanCloud")) {
            return AzureEnvironment.AZURE_GERMANY;
        }
        if (this.environmentName.equalsIgnoreCase("AzureUSGovernment")) {
            return AzureEnvironment.AZURE_US_GOVERNMENT;
        }
        return null;
    }

    String tenant() {
        return this.tenantId;
    }

    boolean isServicePrincipal() {
        return this.user.type.equalsIgnoreCase("ServicePrincipal");
    }

    String userName() {
        return this.user.name;
    }

    synchronized AzureTokenCredentials credentialInstance() {
        if (this.credentialInstance != null) {
            return this.credentialInstance;
        }
        this.credentialInstance = this.isServicePrincipal() ? new ApplicationTokenCredentials(this.clientId(), this.tenant(), this.servicePrincipalToken.accessToken(), this.environment()) : new UserTokenCredentials(this.clientId(), this.tenant(), null, null, this.environment()){

            @Override
            public synchronized String getToken(String resource) throws IOException {
                boolean shouldRefresh;
                AzureCliToken token = (AzureCliToken)AzureCliSubscription.this.userTokens.get(resource);
                if (token == null && resource.equalsIgnoreCase(this.environment().resourceManagerEndpoint())) {
                    token = (AzureCliToken)AzureCliSubscription.this.userTokens.get(this.environment().managementEndpoint());
                }
                if (token != null && !token.expired()) {
                    return token.accessToken();
                }
                boolean bl = shouldRefresh = token != null;
                if (token == null) {
                    token = (AzureCliToken)new ArrayList(AzureCliSubscription.this.userTokens.values()).get(0);
                    shouldRefresh = token.isMRRT();
                }
                if (shouldRefresh) {
                    AuthenticationResult authenticationResult = this.acquireAccessTokenFromRefreshToken(resource, token.refreshToken(), token.isMRRT());
                    if (authenticationResult == null) {
                        return null;
                    }
                    try {
                        AzureCliToken newToken = token.clone().withResource(resource).withAuthenticationResult(authenticationResult);
                        AzureCliSubscription.this.userTokens.put(resource, newToken);
                        return newToken.accessToken();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
        return this.credentialInstance;
    }

    static class Wrapper {
        List<AzureCliSubscription> subscriptions;

        Wrapper() {
        }
    }

    private static class UserInfo {
        private String type;
        private String name;

        private UserInfo() {
        }
    }
}

