/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.google.common.io.BaseEncoding;
import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AuthFile;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApplicationTokenCredentials
extends AzureTokenCredentials {
    private Map<String, AuthenticationResult> tokens;
    private String clientId;
    private String clientSecret;
    private byte[] clientCertificate;
    private String clientCertificatePassword;

    public ApplicationTokenCredentials(String clientId, String domain, String secret, AzureEnvironment environment) {
        super(environment, domain);
        this.clientId = clientId;
        this.clientSecret = secret;
        this.tokens = new HashMap<String, AuthenticationResult>();
    }

    public ApplicationTokenCredentials(String clientId, String domain, byte[] certificate, String password, AzureEnvironment environment) {
        super(environment, domain);
        this.clientId = clientId;
        this.clientCertificate = certificate;
        this.clientCertificatePassword = password;
        this.tokens = new HashMap<String, AuthenticationResult>();
    }

    public static ApplicationTokenCredentials fromFile(File credentialsFile) throws IOException {
        return AuthFile.parse(credentialsFile).generateCredentials();
    }

    public String clientId() {
        return this.clientId;
    }

    public synchronized String getToken(String resource) throws IOException {
        AuthenticationResult authenticationResult = this.tokens.get(resource);
        if (authenticationResult == null || authenticationResult.getExpiresOnDate().before(new Date())) {
            authenticationResult = this.acquireAccessToken(resource);
        }
        this.tokens.put(resource, authenticationResult);
        return authenticationResult.getAccessToken();
    }

    private AuthenticationResult acquireAccessToken(String resource) throws IOException {
        String authorityUrl = this.environment().activeDirectoryEndpoint() + this.domain();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AuthenticationContext context = new AuthenticationContext(authorityUrl, false, executor);
        if (this.proxy() != null) {
            context.setProxy(this.proxy());
        }
        try {
            if (this.clientSecret != null) {
                AuthenticationResult authenticationResult = (AuthenticationResult)context.acquireToken(resource, new ClientCredential(this.clientId(), this.clientSecret), null).get();
                return authenticationResult;
            }
            if (this.clientCertificate != null && this.clientCertificatePassword != null) {
                AuthenticationResult authenticationResult = (AuthenticationResult)context.acquireToken(resource, AsymmetricKeyCredential.create((String)this.clientId, (InputStream)new ByteArrayInputStream(this.clientCertificate), (String)this.clientCertificatePassword), null).get();
                return authenticationResult;
            }
            if (this.clientCertificate != null) {
                AuthenticationResult authenticationResult = (AuthenticationResult)context.acquireToken(resource, AsymmetricKeyCredential.create((String)this.clientId(), (PrivateKey)this.privateKeyFromPem(new String(this.clientCertificate)), (X509Certificate)this.publicKeyFromPem(new String(this.clientCertificate))), null).get();
                return authenticationResult;
            }
            try {
                throw new AuthenticationException("Please provide either a non-null secret or a non-null certificate.");
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private PrivateKey privateKeyFromPem(String pem) {
        Pattern pattern = Pattern.compile("(?s)-----BEGIN PRIVATE KEY-----.*-----END PRIVATE KEY-----");
        Matcher matcher = pattern.matcher(pem);
        matcher.find();
        String base64 = matcher.group().replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("\n", "").replace("\r", "");
        byte[] key = BaseEncoding.base64().decode((CharSequence)base64);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key);
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private X509Certificate publicKeyFromPem(String pem) {
        Pattern pattern = Pattern.compile("(?s)-----BEGIN CERTIFICATE-----.*-----END CERTIFICATE-----");
        Matcher matcher = pattern.matcher(pem);
        matcher.find();
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream stream = new ByteArrayInputStream(matcher.group().getBytes());
            return (X509Certificate)factory.generateCertificate(stream);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

