/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.io.FileUtils;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.io.IOUtils;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import com.microsoft.applicationinsights.internal.util.LocalFileSystemUtils;
import com.microsoft.applicationinsights.internal.util.PropertyHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JniPCConnector {
    public static final String AI_BASE_FOLDER = "AISDK";
    public static final String AI_NATIVE_FOLDER = "native";
    public static final String PROCESS_SELF_INSTANCE_NAME = "__SELF__";
    private static final String BITS_MODEL_64 = "64";
    private static final String NATIVE_LIBRARY_64 = "applicationinsights-core-native-win64.dll";
    private static final String NATIVE_LIBRARY_32 = "applicationinsights-core-native-win32.dll";
    private static String currentInstanceName;

    private static native String getInstanceName(int var0);

    private static native String addCounter(String var0, String var1, String var2);

    private static native double getPerformanceCounterValue(String var0);

    public static boolean initialize() {
        try {
            if (!SystemInformation.INSTANCE.isWindows()) {
                InternalLogger.INSTANCE.error("Jni connector is only used on Windows OS.", new Object[0]);
                return false;
            }
            JniPCConnector.loadNativeLibrary();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (JNIPerformanceCounterConnectorException e) {
            if (InternalLogger.INSTANCE.isErrorEnabled()) {
                InternalLogger.INSTANCE.error("Error initializing JNI Performance Counter library. Windows performance counters will not be used.: " + ExceptionUtils.getStackTrace(e), new Object[0]);
            }
        }
        catch (Throwable e) {
            try {
                if (InternalLogger.INSTANCE.isErrorEnabled()) {
                    InternalLogger.INSTANCE.error("Unexpected error initializing JNI Performance Counter library. Windows performance counters will not be used: " + ExceptionUtils.getStackTrace(e), new Object[0]);
                }
                return false;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    public static String addPerformanceCounter(String category, String counter, String instance) {
        String s;
        if (StringUtils.isEmpty(category)) {
            throw new IllegalArgumentException("category must be non-null non empty string.");
        }
        if (StringUtils.isEmpty(counter)) {
            throw new IllegalArgumentException("counter must be non-null non empty string.");
        }
        if (InternalLogger.INSTANCE.isTraceEnabled()) {
            InternalLogger.INSTANCE.trace("Registering performance counter: %s\\%s [%s]", category, counter, StringUtils.trimToEmpty(instance));
        }
        if (StringUtils.isEmpty(s = JniPCConnector.addCounter(category, counter, instance)) && InternalLogger.INSTANCE.isWarnEnabled()) {
            InternalLogger.INSTANCE.warn("Performance coutner registration failed for %s\\%s [%s]", category, counter, StringUtils.trimToEmpty(instance));
        }
        return s;
    }

    public static String translateInstanceName(String instanceName) throws Exception {
        if (PROCESS_SELF_INSTANCE_NAME.equals(instanceName)) {
            if (StringUtils.isEmpty(currentInstanceName)) {
                throw new Exception("Cannot translate instance name: Unknown current instance name");
            }
            return currentInstanceName;
        }
        return instanceName;
    }

    public static double getValueOfPerformanceCounter(String name) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("name must be non-null non empty value.");
        }
        return JniPCConnector.getPerformanceCounterValue(name);
    }

    private static void initNativeCode() {
        int processId = Integer.parseInt(SystemInformation.INSTANCE.getProcessId());
        currentInstanceName = JniPCConnector.getInstanceName(processId);
        if (StringUtils.isEmpty(currentInstanceName)) {
            InternalLogger.INSTANCE.error("Failed to fetch current process instance name, process counters for for the process level will not be activated.", new Object[0]);
        } else {
            InternalLogger.INSTANCE.info("Java process instance name is set to '%s'", currentInstanceName);
        }
    }

    private static void loadNativeLibrary() throws JNIPerformanceCounterConnectorException {
        File dllOnDisk;
        String libraryToLoad;
        try {
            String model = System.getProperty("sun.arch.data.model");
            libraryToLoad = BITS_MODEL_64.equals(model) ? NATIVE_LIBRARY_64 : NATIVE_LIBRARY_32;
            File dllPath = JniPCConnector.buildDllLocalPath();
            dllOnDisk = new File(dllPath, libraryToLoad);
            if (!dllOnDisk.exists()) {
                JniPCConnector.extractToLocalFolder(dllOnDisk, libraryToLoad);
            } else if (InternalLogger.INSTANCE.isTraceEnabled()) {
                InternalLogger.INSTANCE.trace("Found existing DLL: " + dllOnDisk.getAbsolutePath(), new Object[0]);
            }
        }
        catch (Exception e) {
            throw new JNIPerformanceCounterConnectorException("Error extracting DLL to disk", e);
        }
        try {
            System.load(dllOnDisk.toString());
        }
        catch (Exception e) {
            throw new JNIPerformanceCounterConnectorException("Error loading DLL. Please make sure that Visual C++ 2015 Redistributable is properly installed", e);
        }
        try {
            JniPCConnector.initNativeCode();
        }
        catch (NumberFormatException e) {
            throw new JNIPerformanceCounterConnectorException("Could not parse PID as int", e);
        }
        catch (Exception e) {
            throw new JNIPerformanceCounterConnectorException("Unexpected error initializing performance counter DLL library", e);
        }
        InternalLogger.INSTANCE.trace("Successfully loaded library '%s'", libraryToLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractToLocalFolder(File dllOnDisk, String libraryToLoad) throws IOException {
        InputStream in;
        ClassLoader classLoader = JniPCConnector.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((in = classLoader.getResourceAsStream(libraryToLoad)) == null) {
            throw new RuntimeException(String.format("Failed to find '%s' in jar", libraryToLoad));
        }
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(dllOnDisk);
            IOUtils.copy(in, (OutputStream)out);
            InternalLogger.INSTANCE.trace("Successfully extracted '%s' to local folder", libraryToLoad);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException e) {
                InternalLogger.INSTANCE.error("Failed to close input stream for dll extraction: %s", e.toString());
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    InternalLogger.INSTANCE.error("Failed to close output stream for dll extraction: %s", e.toString());
                }
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to close input stream for dll extraction: %s", e.toString());
        }
        if (out != null) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                InternalLogger.INSTANCE.error("Failed to close output stream for dll extraction: %s", e.toString());
            }
        }
    }

    private static File buildDllLocalPath() {
        File dllPath = LocalFileSystemUtils.getTempDir();
        dllPath = new File(dllPath.toString(), AI_BASE_FOLDER);
        dllPath = new File(dllPath.toString(), AI_NATIVE_FOLDER);
        if (!(dllPath = new File(dllPath.toString(), PropertyHelper.getSdkVersionNumber())).exists()) {
            dllPath.mkdirs();
        }
        if (!(dllPath.exists() && dllPath.canRead() && dllPath.canWrite())) {
            throw new RuntimeException("Failed to create a read/write folder for the native dll.");
        }
        InternalLogger.INSTANCE.trace("%s folder exists", dllPath.toString());
        return dllPath;
    }

    private static class JNIPerformanceCounterConnectorException
    extends Exception {
        public JNIPerformanceCounterConnectorException(String s) {
            super(s);
        }

        public JNIPerformanceCounterConnectorException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }
}

