/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.logger;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.internal.logger.ConsoleLoggerOutput;
import com.microsoft.applicationinsights.internal.logger.FileLoggerOutput;
import com.microsoft.applicationinsights.internal.logger.LoggerOutput;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public enum InternalLogger {
    INSTANCE;

    private static final String LOGGER_LEVEL = "Level";
    private static final SimpleDateFormat dateFormatter;
    private volatile boolean initialized = false;
    private volatile boolean propsNotFound = false;
    private LoggingLevel loggingLevel = LoggingLevel.OFF;
    private LoggerOutput loggerOutput = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String loggerOutputType, Map<String, String> loggerData) {
        InternalLogger internalLogger = INSTANCE;
        synchronized (internalLogger) {
            if (this.initialized) {
                return;
            }
            try {
                String loggerLevel = loggerData.get(LOGGER_LEVEL);
                if (StringUtils.isEmpty(loggerLevel)) {
                    this.loggingLevel = LoggingLevel.TRACE;
                    this.setLoggerOutput(loggerOutputType, loggerData);
                } else {
                    try {
                        this.loggingLevel = LoggingLevel.valueOf(loggerLevel.toUpperCase());
                        this.setLoggerOutput(loggerOutputType, loggerData);
                    }
                    catch (Exception e) {
                        this.onInitializationError(String.format("Error: Illegal value '%s' for the SDK internal logger. Logging level is therefore set to 'OFF'", loggerLevel));
                    }
                }
                String utcId = "UTC";
                try {
                    dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                }
                catch (Exception e) {
                    new ConsoleLoggerOutput().log(String.format("Failed to find timezone with id='%s'. Using default '%s'", "UTC", dateFormatter.getTimeZone().getDisplayName()));
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean systemPropertyInitialize() {
        InternalLogger internalLogger = INSTANCE;
        synchronized (internalLogger) {
            String file;
            if (this.propsNotFound || this.initialized) {
                return this.initialized;
            }
            String console = System.getProperty("applicationinsights.logger.console.level");
            String level = StringUtils.defaultString(console, file = System.getProperty("applicationinsights.logger.file.level"));
            if (level == null) {
                this.propsNotFound = true;
                return this.initialized;
            }
            String type = console == null ? LoggerOutputType.FILE.toString() : LoggerOutputType.CONSOLE.toString();
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(LOGGER_LEVEL, level);
            if (file != null) {
                this.populateMapForFileLogging(props);
            }
            this.initialize(type, props);
            return this.initialized;
        }
    }

    private void populateMapForFileLogging(Map<String, String> props) {
        String fileSize;
        String numFiles;
        String basePath;
        String prefix = System.getProperty("applicationinsights.logger.file.uniquePrefix");
        if (prefix != null) {
            props.put("UniquePrefix", prefix);
        }
        if ((basePath = System.getProperty("applicationinsights.logger.file.baseFolderPath")) != null) {
            props.put("BaseFolderPath", basePath);
        }
        if ((numFiles = System.getProperty("applicationinsights.logger.file.numberOfFiles")) != null) {
            props.put("NumberOfFiles", numFiles);
        }
        if ((fileSize = System.getProperty("applicationinsights.logger.file.numberOfTotalSizeInMB")) != null) {
            props.put("NumberOfTotalSizeInMB", fileSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        InternalLogger internalLogger = INSTANCE;
        synchronized (internalLogger) {
            if (this.loggingLevel.equals((Object)LoggingLevel.OFF)) {
                return;
            }
            try {
                if (this.loggerOutput != null) {
                    this.loggerOutput.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.loggingLevel = LoggingLevel.OFF;
        }
    }

    void reset() {
        INSTANCE.stop();
        InternalLogger.INSTANCE.initialized = false;
    }

    public boolean isTraceEnabled() {
        return this.loggingLevel.getValue() <= LoggingLevel.TRACE.getValue();
    }

    public boolean isInfoEnabled() {
        return this.loggingLevel.getValue() <= LoggingLevel.INFO.getValue();
    }

    public boolean isWarnEnabled() {
        return this.loggingLevel.getValue() <= LoggingLevel.WARN.getValue();
    }

    public boolean isErrorEnabled() {
        return this.loggingLevel.getValue() <= LoggingLevel.ERROR.getValue();
    }

    public void error(String message, Object ... args) {
        try {
            this.log(LoggingLevel.ERROR, message, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void warn(String message, Object ... args) {
        try {
            this.log(LoggingLevel.WARN, message, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void info(String message, Object ... args) {
        try {
            this.log(LoggingLevel.INFO, message, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trace(String message, Object ... args) {
        try {
            this.log(LoggingLevel.TRACE, message, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    public void logAlways(LoggingLevel requestLevel, String message, Object ... args) {
        String logMessage = InternalLogger.createMessage(requestLevel.toString(), message, args);
        if (!this.initialized || this.loggerOutput == null) {
            new ConsoleLoggerOutput().log(logMessage);
        } else {
            this.loggerOutput.log(logMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createMessage(String prefix, String message, Object ... args) {
        String currentDateAsString;
        InternalLogger internalLogger = INSTANCE;
        synchronized (internalLogger) {
            currentDateAsString = dateFormatter.format(new Date());
        }
        String formattedMessage = String.format(message, args);
        Thread thisThread = Thread.currentThread();
        return String.format("%s %s, %d(%s): %s", prefix, currentDateAsString, thisThread.getId(), thisThread.getName(), formattedMessage);
    }

    private void setLoggerOutput(String loggerOutputType, Map<String, String> loggerData) {
        if (this.loggingLevel.equals((Object)LoggingLevel.OFF)) {
            this.loggerOutput = null;
            return;
        }
        LoggerOutputType type = LoggerOutputType.CONSOLE;
        if (StringUtils.isNotEmpty(loggerOutputType)) {
            try {
                type = LoggerOutputType.valueOf(loggerOutputType.toUpperCase());
            }
            catch (Exception e) {
                System.err.println(e);
                this.onInitializationError(String.format("Error: Illegal value '%s' for the SDK Internal Logger type.", loggerOutputType));
                return;
            }
        }
        switch (type) {
            case CONSOLE: {
                this.loggerOutput = new ConsoleLoggerOutput();
                return;
            }
            case FILE: {
                try {
                    this.loggerOutput = new FileLoggerOutput(loggerData);
                }
                catch (Exception e) {
                    this.onInitializationError(String.format("SDK Internal Logger internal error while initializing 'FILE': '%s'.", e.toString()));
                }
                return;
            }
        }
    }

    private void onInitializationError(String errorMessage) {
        try {
            this.loggerOutput = null;
            this.loggingLevel = LoggingLevel.OFF;
            new ConsoleLoggerOutput().log(errorMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void log(LoggingLevel requestLevel, String message, Object ... args) {
        if (!this.initialized && !this.systemPropertyInitialize()) {
            return;
        }
        if (requestLevel.getValue() >= this.loggingLevel.getValue()) {
            this.loggerOutput.log(InternalLogger.createMessage(requestLevel.toString(), message, args));
        }
    }

    static {
        dateFormatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSSZ");
    }

    public static enum LoggerOutputType {
        CONSOLE,
        FILE;

    }

    public static enum LoggingLevel {
        ALL(Integer.MIN_VALUE),
        TRACE(10000),
        INFO(20000),
        WARN(30000),
        ERROR(40000),
        OFF(50000);

        private int value;

        private LoggingLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class PropertyKeys {
        private static final String SDKLOGGER_PREFIX = "applicationinsights.logger.";
        public static final String CONSOLE_LEVEL = "applicationinsights.logger.console.level";
        public static final String FILE_LEVEL = "applicationinsights.logger.file.level";
        public static final String FILE_UNIQUE_PREFIX = "applicationinsights.logger.file.uniquePrefix";
        public static final String FILE_BASE_FOLDER_PATH = "applicationinsights.logger.file.baseFolderPath";
        public static final String FILE_NUMBER_OF_FILES = "applicationinsights.logger.file.numberOfFiles";
        public static final String FILE_MAX_LOGFILE_SIZE_IN_MB = "applicationinsights.logger.file.numberOfTotalSizeInMB";
    }
}

