/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.impl.nio.pool;

import com.microsoft.applicationinsights.web.dependencies.http.HttpHost;
import com.microsoft.applicationinsights.web.dependencies.http.HttpRequest;
import com.microsoft.applicationinsights.web.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.web.dependencies.http.HttpResponseFactory;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.web.dependencies.http.config.ConnectionConfig;
import com.microsoft.applicationinsights.web.dependencies.http.impl.DefaultHttpResponseFactory;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.DefaultNHttpClientConnectionFactory;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.SSLNHttpClientConnectionFactory;
import com.microsoft.applicationinsights.web.dependencies.http.nio.NHttpClientConnection;
import com.microsoft.applicationinsights.web.dependencies.http.nio.NHttpConnectionFactory;
import com.microsoft.applicationinsights.web.dependencies.http.nio.NHttpMessageParserFactory;
import com.microsoft.applicationinsights.web.dependencies.http.nio.NHttpMessageWriterFactory;
import com.microsoft.applicationinsights.web.dependencies.http.nio.pool.NIOConnFactory;
import com.microsoft.applicationinsights.web.dependencies.http.nio.reactor.IOSession;
import com.microsoft.applicationinsights.web.dependencies.http.nio.reactor.ssl.SSLSetupHandler;
import com.microsoft.applicationinsights.web.dependencies.http.nio.util.ByteBufferAllocator;
import com.microsoft.applicationinsights.web.dependencies.http.nio.util.HeapByteBufferAllocator;
import com.microsoft.applicationinsights.web.dependencies.http.params.HttpParams;
import com.microsoft.applicationinsights.web.dependencies.http.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicNIOConnFactory
implements NIOConnFactory<HttpHost, NHttpClientConnection> {
    private final NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory;
    private final NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory;

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory, NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory) {
        Args.notNull(plainFactory, "Plain HTTP client connection factory");
        this.plainFactory = plainFactory;
        this.sslFactory = sslFactory;
    }

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory) {
        this(plainFactory, null);
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        this(new DefaultNHttpClientConnectionFactory(responseFactory, allocator, params), new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, responseFactory, allocator, params));
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslcontext, sslHandler, DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    public BasicNIOConnFactory(HttpParams params) {
        this(null, null, params);
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(responseParserFactory, requestWriterFactory, allocator, config), new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, responseParserFactory, requestWriterFactory, allocator, config));
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, ConnectionConfig config) {
        this(sslcontext, sslHandler, null, null, null, config);
    }

    public BasicNIOConnFactory(ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(config), null);
    }

    @Override
    public NHttpClientConnection create(HttpHost route, IOSession session) throws IOException {
        NHttpClientConnection conn;
        if (route.getSchemeName().equalsIgnoreCase("https")) {
            if (this.sslFactory == null) {
                throw new IOException("SSL not supported");
            }
            conn = this.sslFactory.createConnection(session);
        } else {
            conn = this.plainFactory.createConnection(session);
        }
        session.setAttribute("http.connection", conn);
        return conn;
    }
}

