/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Preconditions;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;

public final class LimitsEnforcer {
    private final Type type;
    private final int maximum;
    private final int minimum;
    private final int defaultValue;
    private final String propertyName;
    private int currentValue;

    public Type getType() {
        return this.type;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public int normalizeValue(Integer value) {
        switch (this.type) {
            case DEFAULT_ON_ERROR: {
                if (value == null || value < this.minimum || value > this.maximum) {
                    InternalLogger.INSTANCE.warn("'%s': bad value is replaced by the default: '%d'", this.propertyName, this.defaultValue);
                    this.currentValue = this.defaultValue;
                    break;
                }
                this.currentValue = value;
                break;
            }
            case CLOSEST_LIMIT_ON_ERROR: {
                if (value == null) {
                    this.currentValue = this.defaultValue;
                    InternalLogger.INSTANCE.info("'%s': null value is replaced with '%d'", this.propertyName, this.defaultValue);
                    break;
                }
                if (value < this.minimum) {
                    this.currentValue = this.minimum;
                    InternalLogger.INSTANCE.warn("'%s': value is under the minimum, therefore is replaced with '%d'", this.propertyName, this.minimum);
                    break;
                }
                if (value > this.maximum) {
                    this.currentValue = this.maximum;
                    InternalLogger.INSTANCE.warn("'%s': value is above the maximum, therefore is replaced with '%d'", this.propertyName, this.maximum);
                    break;
                }
                this.currentValue = value;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown type %s", new Object[]{this.type}));
            }
        }
        return this.currentValue;
    }

    public int normalizeStringValue(String value) {
        return this.normalizeValue(LimitsEnforcer.translate(this.propertyName, value));
    }

    private LimitsEnforcer(Type type, int minimum, int maximum, int defaultValue, Integer currentValue, String propertyName) {
        Preconditions.checkState(maximum >= minimum, "maximum must be >= than minimum");
        Preconditions.checkState(defaultValue >= minimum && defaultValue <= maximum, "defaultValue must be: 'defaultValue >= minimum && defaultValue <= maximum");
        this.propertyName = propertyName;
        this.type = type;
        this.maximum = maximum;
        this.minimum = minimum;
        this.defaultValue = defaultValue;
        this.currentValue = this.normalizeValue(currentValue);
    }

    public static LimitsEnforcer createWithDefaultOnError(String propertyName, int minimum, int maximum, int defaultValue, Integer currentValue) {
        return new LimitsEnforcer(Type.DEFAULT_ON_ERROR, minimum, maximum, defaultValue, currentValue, propertyName);
    }

    public static LimitsEnforcer createWithDefaultOnError(int minimum, int maximum, int defaultValue, String propertyName, String currentValue) {
        return new LimitsEnforcer(Type.DEFAULT_ON_ERROR, minimum, maximum, defaultValue, LimitsEnforcer.translate(propertyName, currentValue), propertyName);
    }

    public static LimitsEnforcer createWithClosestLimitOnError(String propertyName, int minimum, int maximum, int defaultValue, Integer currentValue) {
        return new LimitsEnforcer(Type.CLOSEST_LIMIT_ON_ERROR, minimum, maximum, defaultValue, currentValue, propertyName);
    }

    public static LimitsEnforcer createWithClosestLimitOnError(int minimum, int maximum, int defaultValue, String propertyName, String currentValue) {
        return new LimitsEnforcer(Type.CLOSEST_LIMIT_ON_ERROR, minimum, maximum, defaultValue, LimitsEnforcer.translate(propertyName, currentValue), propertyName);
    }

    private static Integer translate(String propertyName, String valueAsString) {
        Integer value = null;
        if (valueAsString != null) {
            try {
                value = Integer.parseInt(valueAsString);
            }
            catch (NumberFormatException e) {
                InternalLogger.INSTANCE.warn("'%s': bad format for value '%s'", propertyName, valueAsString);
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
            }
        }
        return value;
    }

    static enum Type {
        DEFAULT_ON_ERROR,
        CLOSEST_LIMIT_ON_ERROR;

    }
}

