/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryChannel;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.extensibility.initializer.DeviceInfoContextInitializer;
import com.microsoft.applicationinsights.extensibility.initializer.SdkVersionContextInitializer;
import com.microsoft.applicationinsights.extensibility.initializer.SequencePropertyInitializer;
import com.microsoft.applicationinsights.extensibility.initializer.TimestampPropertyInitializer;
import com.microsoft.applicationinsights.extensibility.initializer.docker.DockerContextInitializer;
import com.microsoft.applicationinsights.internal.channel.samplingV2.FixedRateSamplingTelemetryProcessor;
import com.microsoft.applicationinsights.internal.channel.stdout.StdOutChannel;
import com.microsoft.applicationinsights.internal.config.AddTypeXmlElement;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatModule;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.JvmPerformanceCountersModule;
import com.microsoft.applicationinsights.internal.perfcounter.ProcessPerformanceCountersModule;
import com.microsoft.applicationinsights.internal.processor.MetricTelemetryFilter;
import com.microsoft.applicationinsights.internal.processor.PageViewTelemetryFilter;
import com.microsoft.applicationinsights.internal.processor.RequestTelemetryFilter;
import com.microsoft.applicationinsights.internal.processor.SyntheticSourceFilter;
import com.microsoft.applicationinsights.internal.processor.TelemetryEventFilter;
import com.microsoft.applicationinsights.internal.processor.TraceTelemetryFilter;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReflectionUtils {
    private static final Map<String, Class<?>> builtInMap = new HashMap();

    static void addClass(Class<?> clazz) {
        builtInMap.put(clazz.getCanonicalName(), clazz);
    }

    public static <T> T createInstance(String className, Class<T> interfaceClass) {
        try {
            if (LocalStringsUtils.isNullOrEmpty(className)) {
                InternalLogger.INSTANCE.error("Failed to create empty class name", new Object[0]);
                return null;
            }
            Class<Object> clazz = builtInMap.get(className);
            clazz = clazz == null ? Class.forName(className).asSubclass(interfaceClass) : clazz.asSubclass(interfaceClass);
            Object instance = clazz.newInstance();
            return (T)instance;
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to create %s, Exception : %s", className, ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static <T, A> T createInstance(String className, Class<T> interfaceClass, Class<A> argumentClass, A argument) {
        try {
            if (LocalStringsUtils.isNullOrEmpty(className)) {
                InternalLogger.INSTANCE.error("Failed to create empty class name", new Object[0]);
                return null;
            }
            Class<Object> clazz = builtInMap.get(className);
            clazz = clazz == null ? Class.forName(className).asSubclass(interfaceClass) : clazz.asSubclass(interfaceClass);
            Constructor<Object> clazzConstructor = clazz.getConstructor(argumentClass);
            return (T)clazzConstructor.newInstance(argument);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to create %s, Exception : %s", className, ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    static <T> T createConfiguredInstance(String className, Class<T> interfaceClass, TelemetryConfiguration configuration, Map<String, String> componentConfig) {
        try {
            if (LocalStringsUtils.isNullOrEmpty(className)) {
                return null;
            }
            Class<Object> clazz = builtInMap.get(className);
            clazz = clazz == null ? Class.forName(className).asSubclass(interfaceClass) : clazz.asSubclass(interfaceClass);
            Constructor<Object> clazzConstructor = clazz.getConstructor(TelemetryConfiguration.class, Map.class);
            return (T)clazzConstructor.newInstance(configuration, componentConfig);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to instantiate %s: %s", className, ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static <V, A> boolean activateMethod(Object object, String methodName, V value, A argumentClass) {
        Class<?> clazz = object.getClass();
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, String.class);
            method.invoke(object, value);
            return true;
        }
        catch (NoSuchMethodException e) {
            InternalLogger.INSTANCE.error("Failed to call method %s .NoSuchMethodException", methodName);
        }
        catch (InvocationTargetException e) {
            InternalLogger.INSTANCE.error("Failed to call method %s .InvocationTargetException", methodName);
        }
        catch (IllegalAccessException e) {
            InternalLogger.INSTANCE.error("Failed to call method %s .IllegalAccessException", methodName);
        }
        return false;
    }

    public static <T> void loadComponents(Class<T> clazz, List<T> list, Collection<AddTypeXmlElement> classNames) {
        if (classNames == null) {
            return;
        }
        for (AddTypeXmlElement className : classNames) {
            Object initializer = null;
            if (className.getParameters().size() != 0) {
                initializer = ReflectionUtils.createInstance(className.getType(), clazz, Map.class, className.getData());
            }
            if (initializer == null) {
                initializer = ReflectionUtils.createInstance(className.getType(), clazz);
            }
            if (initializer == null) continue;
            list.add(initializer);
        }
    }

    static {
        ReflectionUtils.addClass(InProcessTelemetryChannel.class);
        ReflectionUtils.addClass(StdOutChannel.class);
        ReflectionUtils.addClass(HeartBeatModule.class);
        ReflectionUtils.addClass(JvmPerformanceCountersModule.class);
        ReflectionUtils.addClass(ProcessPerformanceCountersModule.class);
        ReflectionUtils.addClass(SdkVersionContextInitializer.class);
        ReflectionUtils.addClass(DeviceInfoContextInitializer.class);
        ReflectionUtils.addClass(TimestampPropertyInitializer.class);
        ReflectionUtils.addClass(SequencePropertyInitializer.class);
        ReflectionUtils.addClass(DockerContextInitializer.class);
        ReflectionUtils.addClass(MetricTelemetryFilter.class);
        ReflectionUtils.addClass(RequestTelemetryFilter.class);
        ReflectionUtils.addClass(FixedRateSamplingTelemetryProcessor.class);
        ReflectionUtils.addClass(SyntheticSourceFilter.class);
        ReflectionUtils.addClass(PageViewTelemetryFilter.class);
        ReflectionUtils.addClass(TelemetryEventFilter.class);
        ReflectionUtils.addClass(TraceTelemetryFilter.class);
    }
}

