/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.samplingV2;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.annotation.BuiltInProcessor;
import com.microsoft.applicationinsights.internal.channel.samplingV2.SamplingScoreGeneratorV2;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.EventTelemetry;
import com.microsoft.applicationinsights.telemetry.ExceptionTelemetry;
import com.microsoft.applicationinsights.telemetry.PageViewTelemetry;
import com.microsoft.applicationinsights.telemetry.RemoteDependencyTelemetry;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.telemetry.SupportSampling;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.telemetry.TraceTelemetry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@BuiltInProcessor(value="FixedRateSamplingTelemetryProcessor")
public final class FixedRateSamplingTelemetryProcessor
implements TelemetryProcessor {
    public static final double DEFAULT_SAMPLING_PERCENTAGE = 100.0;
    private static Map<String, Class> allowedTypes = new HashMap<String, Class>();
    private static final String dependencyTelemetryName = "Dependency";
    private static final String eventTelemetryName = "Event";
    private static final String exceptionTelemetryName = "Exception";
    private static final String pageViewTelemetryName = "PageView";
    private static final String requestTelemetryName = "Request";
    private static final String traceTelemetryName = "Trace";
    private Set<Class> excludedTypes;
    private Set<Class> includedTypes = new HashSet<Class>();
    private double samplingPercentage = 100.0;

    public FixedRateSamplingTelemetryProcessor() {
        this.excludedTypes = new HashSet<Class>();
    }

    public Set<Class> getExcludedTypes() {
        return this.excludedTypes;
    }

    public Set<Class> getIncludedTypes() {
        return this.includedTypes;
    }

    private void setIncludedOrExcludedTypes(String value, Set<Class> typeSet, String verb) {
        Class type = allowedTypes.get(StringUtils.trimToEmpty(value));
        if (type != null) {
            typeSet.add(type);
        } else {
            InternalLogger.INSTANCE.error("Error configuring %s: %s is not a valid telemetry type to %s.", FixedRateSamplingTelemetryProcessor.class.getSimpleName(), value, verb);
        }
    }

    double getSamplingPercentage() {
        return this.samplingPercentage;
    }

    public void setSamplingPercentage(String samplingPercentage) {
        block2: {
            try {
                this.samplingPercentage = Double.parseDouble(samplingPercentage);
                InternalLogger.INSTANCE.info("Sampling rate set to %s", samplingPercentage);
            }
            catch (NumberFormatException ex) {
                this.samplingPercentage = 100.0;
                if (!InternalLogger.INSTANCE.isErrorEnabled()) break block2;
                InternalLogger.INSTANCE.error("Sampling rate specified in improper format. Using default sampling rate, 100.0: %s", ExceptionUtils.getStackTrace(ex));
            }
        }
    }

    @Override
    public boolean process(Telemetry telemetry) {
        double sp = this.samplingPercentage;
        if (telemetry instanceof SupportSampling) {
            if (this.isSamplingApplicable(telemetry.getClass())) {
                SupportSampling samplingSupportingTelemetry = (SupportSampling)((Object)telemetry);
                if (samplingSupportingTelemetry.getSamplingPercentage() == null) {
                    samplingSupportingTelemetry.setSamplingPercentage(sp);
                } else {
                    InternalLogger.INSTANCE.info("Item has sampling percentage already set to :" + samplingSupportingTelemetry.getSamplingPercentage(), new Object[0]);
                    sp = samplingSupportingTelemetry.getSamplingPercentage();
                }
                if (SamplingScoreGeneratorV2.getSamplingScore(telemetry) >= sp) {
                    InternalLogger.INSTANCE.trace("Item %s sampled out", telemetry.getClass().getSimpleName());
                    return false;
                }
            } else {
                InternalLogger.INSTANCE.trace("Skip sampling since %s type is not sampling applicable", telemetry.getClass().getSimpleName());
            }
        }
        return true;
    }

    private boolean isSamplingApplicable(Class item) {
        if (this.excludedTypes.size() > 0 && this.excludedTypes.contains(item)) {
            return false;
        }
        return this.includedTypes.size() <= 0 || this.includedTypes.contains(item);
    }

    public void addToExcludedType(String value) {
        this.setIncludedOrExcludedTypes(value, this.excludedTypes, "exclude");
    }

    public void addToIncludedType(String value) {
        this.setIncludedOrExcludedTypes(value, this.includedTypes, "include");
    }

    static {
        allowedTypes.put(dependencyTelemetryName, RemoteDependencyTelemetry.class);
        allowedTypes.put(eventTelemetryName, EventTelemetry.class);
        allowedTypes.put(exceptionTelemetryName, ExceptionTelemetry.class);
        allowedTypes.put(pageViewTelemetryName, PageViewTelemetry.class);
        allowedTypes.put(requestTelemetryName, RequestTelemetry.class);
        allowedTypes.put(traceTelemetryName, TraceTelemetry.class);
    }
}

