/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.cookies;

import com.microsoft.applicationinsights.extensibility.context.SessionContext;
import com.microsoft.applicationinsights.internal.util.DateTimeUtils;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.cookies.SessionCookie;
import com.microsoft.applicationinsights.web.internal.cookies.UserCookie;
import java.util.Date;
import javax.servlet.http.Cookie;

public class HttpCookieFactory {
    private static final int COOKIE_VERSION = 1;
    public static String COOKIE_PATH_ALL_URL = "/";

    public static Cookie generateSessionHttpCookie(RequestTelemetryContext context, SessionContext sessionContext, int sessionTimeoutInMinutes) {
        Date renewalDate = DateTimeUtils.getDateTimeNow();
        String formattedCookie = SessionCookie.formatCookie(new String[]{sessionContext.getId(), String.valueOf(context.getSessionCookie().getSessionAcquisitionDate().getTime()), String.valueOf(renewalDate.getTime())});
        Cookie cookie = new Cookie("ai_session", formattedCookie);
        cookie.setMaxAge(sessionTimeoutInMinutes * 60);
        HttpCookieFactory.setCommonProperties(cookie);
        return cookie;
    }

    public static Cookie generateUserHttpCookie(RequestTelemetryContext context) {
        String formattedCookie = UserCookie.formatCookie(new String[]{context.getUserCookie().getUserId(), DateTimeUtils.formatAsRoundTripDate(context.getUserCookie().getAcquisitionDate())});
        Cookie cookie = new Cookie("ai_user", formattedCookie);
        cookie.setMaxAge(Integer.MAX_VALUE);
        HttpCookieFactory.setCommonProperties(cookie);
        return cookie;
    }

    private static void setCommonProperties(Cookie cookie) {
        cookie.setPath(COOKIE_PATH_ALL_URL);
        cookie.setVersion(1);
    }
}

