/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.AbstractUnixPerformanceCounter;
import com.microsoft.applicationinsights.telemetry.PerformanceCounterTelemetry;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

final class UnixTotalCpuPerformanceCounter
extends AbstractUnixPerformanceCounter {
    private static final String STAT_FILE = "/proc/stat";
    private long[] prevCpuCounters = null;
    private long prevTotalCpuValue;

    public UnixTotalCpuPerformanceCounter() {
        super(STAT_FILE);
    }

    @Override
    public String getId() {
        return "JSDK_TotalCpuPerformanceCounter";
    }

    @Override
    public void report(TelemetryClient telemetryClient) {
        String line = this.getLineOfData();
        if (!Strings.isNullOrEmpty(line)) {
            String[] rawStringValues = line.split(" ");
            ArrayList<String> stringValues = new ArrayList<String>(rawStringValues.length - 1);
            for (int i = 1; i < rawStringValues.length; ++i) {
                String stringValue = rawStringValues[i];
                if (Strings.isNullOrEmpty(stringValue)) continue;
                stringValues.add(stringValue);
            }
            String[] array = stringValues.toArray(new String[stringValues.size()]);
            if (this.prevCpuCounters == null) {
                this.getCountersForTheFirstTime(array);
                return;
            }
            double totalCpuUsage = this.calculateTotalCpuUsage(array);
            InternalLogger.INSTANCE.trace("Sending Performance Counter: %s %s %s: %s", "Processor", "% Processor Time", "_Total", totalCpuUsage);
            PerformanceCounterTelemetry telemetry = new PerformanceCounterTelemetry("Processor", "% Processor Time", "_Total", totalCpuUsage);
            telemetryClient.track(telemetry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getLineOfData() {
        BufferedReader bufferedReader = null;
        String line = null;
        bufferedReader = new BufferedReader(new FileReader(this.getProcessFile()));
        line = bufferedReader.readLine();
        if (bufferedReader == null) return line;
        try {
            bufferedReader.close();
            return line;
        }
        catch (Exception e) {
            this.logError("Error while closing file : '%s'", e.getMessage());
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
        }
        return line;
        catch (Exception e) {
            try {
                this.logError("Error while parsing file: '%s'", e.getMessage());
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
                if (bufferedReader == null) return line;
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    this.logError("Error while closing file : '%s'", e2.getMessage());
                    InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e2));
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
                return line;
            }
            catch (Exception e3) {
                this.logError("Error while closing file : '%s'", e3.getMessage());
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e3));
            }
            return line;
        }
    }

    private void getCountersForTheFirstTime(String[] stringValues) {
        this.prevCpuCounters = new long[stringValues.length];
        this.prevTotalCpuValue = 0L;
        for (int i = 0; i < stringValues.length; ++i) {
            long value;
            String stringValue = stringValues[i];
            this.prevCpuCounters[i] = value = Long.parseLong(stringValue);
            this.prevTotalCpuValue += value;
        }
    }

    private double calculateTotalCpuUsage(String[] stringValues) {
        long[] cpuCounters = new long[stringValues.length];
        long totalCpuValue = 0L;
        double diffIdle = 0.0;
        for (int i = 0; i < stringValues.length; ++i) {
            String stringValue = stringValues[i];
            long value = Long.parseLong(stringValue);
            cpuCounters[i] = value - this.prevCpuCounters[i];
            this.prevCpuCounters[i] = value;
            totalCpuValue += value;
            if (i != 3) continue;
            diffIdle = cpuCounters[i];
        }
        double totalDiff = totalCpuValue - this.prevTotalCpuValue;
        double result = 100.0 * ((totalDiff - diffIdle) / totalDiff);
        this.prevTotalCpuValue = totalCpuValue;
        return result;
    }
}

