/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.microsoft.applicationinsights.internal.config.AddTypeXmlElement;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ReflectionUtils {
    public static <T> T createInstance(String className, Class<T> interfaceClass) {
        try {
            if (LocalStringsUtils.isNullOrEmpty(className)) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create empty class name", new Object[0]);
                return null;
            }
            Class<T> clazz = Class.forName(className).asSubclass(interfaceClass);
            T instance = clazz.newInstance();
            return instance;
        }
        catch (ClassCastException e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create %s, %s", className, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create %s, %s", className, e.getMessage());
        }
        catch (InstantiationException e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create %s, %s", className, e.getMessage());
        }
        catch (IllegalAccessException e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create %s, %s", className, e.getMessage());
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create %s, %s", className, e.getMessage());
        }
        return null;
    }

    public static <T, A> T createInstance(String className, Class<T> interfaceClass, Class<A> argumentClass, A argument) {
        try {
            if (LocalStringsUtils.isNullOrEmpty(className)) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create empty class name", new Object[0]);
                return null;
            }
            Class<T> clazz = Class.forName(className).asSubclass(interfaceClass);
            Constructor<T> clazzConstructor = clazz.getConstructor(argumentClass);
            T instance = clazzConstructor.newInstance(argument);
            return instance;
        }
        catch (ClassCastException e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create %s, %s", className, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            InternalLogger.INSTANCE.error("Failed to create %s, %s", className, e.getMessage());
        }
        catch (InstantiationException e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create %s, %s", className, e.getMessage());
        }
        catch (IllegalAccessException e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create %s, %s", className, e.getMessage());
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create %s, %s", className, e.getMessage());
        }
        return null;
    }

    public static <V, A> boolean activateMethod(Object object, String methodName, V value, A argumentClass) {
        Class<?> clazz = object.getClass();
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, String.class);
            method.invoke(object, value);
            return true;
        }
        catch (NoSuchMethodException e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to call method " + methodName + ". NoSuchMethodException", new Object[0]);
        }
        catch (InvocationTargetException e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to call method " + methodName + ". InvocationTargetException", new Object[0]);
        }
        catch (IllegalAccessException e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to call method " + methodName + ". IllegalAccessException", new Object[0]);
        }
        return false;
    }

    public static <T> void loadComponents(Class<T> clazz, List<T> list, Collection<AddTypeXmlElement> classNames) {
        if (classNames == null) {
            return;
        }
        for (AddTypeXmlElement className : classNames) {
            Object initializer = null;
            if (className.getParameters().size() != 0) {
                initializer = ReflectionUtils.createInstance(className.getType(), clazz, Map.class, className.getData());
            }
            if (initializer == null) {
                initializer = ReflectionUtils.createInstance(className.getType(), clazz);
            }
            if (initializer == null) continue;
            list.add(initializer);
        }
    }
}

