/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.extensibility.initializer;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.codec.binary.Base64;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.extensibility.TelemetryInitializer;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public final class SequencePropertyInitializer
implements TelemetryInitializer {
    private static final String SEPARATOR = ":";
    private final String stablePrefix;
    private final AtomicLong currentNumber = new AtomicLong(-1L);

    public SequencePropertyInitializer() {
        this.stablePrefix = SequencePropertyInitializer.uuidToBase64() + SEPARATOR;
    }

    @Override
    public void initialize(Telemetry telemetry) {
        String sequence = telemetry.getSequence();
        if (Strings.isNullOrEmpty(sequence)) {
            sequence = this.stablePrefix + String.valueOf(this.currentNumber.incrementAndGet());
            telemetry.setSequence(sequence);
        }
    }

    private static String uuidToBase64() {
        Base64 base64 = new Base64();
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return Base64.encodeBase64URLSafeString(bb.array());
    }
}

