/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.autoconfigure.conditionals;

import com.microsoft.applicationinsights.autoconfigure.helpers.IkeyResolver;
import com.microsoft.applicationinsights.boot.dependencies.apachecommons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class InstrumentationKeyCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        if (StringUtils.isNotBlank(System.getenv("APPLICATIONINSIGHTS_CONNECTION_STRING"))) {
            return new ConditionOutcome(true, ConditionMessage.of((String)"found APPLICATIONINSIGHTS_CONNECTION_STRING", (Object[])new Object[0]));
        }
        String connStringProp = "azure.application-insights.connection-string";
        if (StringUtils.isNotBlank(context.getEnvironment().getProperty("azure.application-insights.connection-string"))) {
            return new ConditionOutcome(true, ConditionMessage.of((String)"found azure.application-insights.connection-string", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank(IkeyResolver.getIkeyFromEnvironmentVariables())) {
            return new ConditionOutcome(true, ConditionMessage.of((String)"found instrumentation key found via environment variable", (Object[])new Object[0]));
        }
        String ikeyProp = "azure.application-insights.instrumentation-key";
        if (StringUtils.isNotBlank(context.getEnvironment().getProperty("azure.application-insights.instrumentation-key"))) {
            return new ConditionOutcome(true, ConditionMessage.of((String)"found azure.application-insights.instrumentation-key", (Object[])new Object[0]));
        }
        return new ConditionOutcome(false, ConditionMessage.of((String)"instrumentation key or connection string not found", (Object[])new Object[0]));
    }
}

