/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.ClassNames;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SpanNames {
    private static final ClassValue<Map<String, String>> spanNameCaches = new ClassValue<Map<String, String>>(){

        @Override
        protected Map<String, String> computeValue(Class<?> clazz) {
            return new ConcurrentHashMap<String, String>();
        }
    };

    public static String fromMethod(Method method) {
        return SpanNames.fromMethod(method.getDeclaringClass(), method.getName());
    }

    public static String fromMethod(Class<?> clazz, @Nullable Method method) {
        return SpanNames.fromMethod(clazz, method == null ? "<unknown>" : method.getName());
    }

    public static String fromMethod(Class<?> clazz, String methodName) {
        Map<String, String> spanNameCache = spanNameCaches.get(clazz);
        String spanName = spanNameCache.get(methodName);
        if (spanName != null) {
            return spanName;
        }
        spanName = ClassNames.simpleName(clazz) + "." + methodName;
        spanNameCache.put(methodName, spanName);
        return spanName;
    }

    private SpanNames() {
    }
}

