/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.servlet;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;

public class AppServerBridge {
    private static final ContextKey<AppServerBridge> CONTEXT_KEY = ContextKey.named("opentelemetry-servlet-app-server-bridge");
    private final boolean servletShouldRecordException;
    private Throwable exception;

    public static Context init(Context ctx) {
        return AppServerBridge.init(ctx, true);
    }

    public static Context init(Context ctx, boolean shouldRecordException) {
        return ctx.with(CONTEXT_KEY, new AppServerBridge(shouldRecordException));
    }

    private AppServerBridge(boolean shouldRecordException) {
        this.servletShouldRecordException = shouldRecordException;
    }

    public static boolean shouldRecordException(Context context) {
        AppServerBridge appServerBridge = context.get(CONTEXT_KEY);
        if (appServerBridge != null) {
            return appServerBridge.servletShouldRecordException;
        }
        return true;
    }

    public static void recordException(Context context, Throwable exception) {
        AppServerBridge appServerBridge = context.get(CONTEXT_KEY);
        if (appServerBridge != null && appServerBridge.servletShouldRecordException) {
            appServerBridge.exception = exception;
        }
    }

    @Nullable
    public static Throwable getException(Context context) {
        AppServerBridge appServerBridge = context.get(CONTEXT_KEY);
        if (appServerBridge != null) {
            return appServerBridge.exception;
        }
        return null;
    }

    public static Class<?> getCallDepthKey() {
        class Key {
            Key() {
            }
        }
        return Key.class;
    }
}

