/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.config;

import com.google.auto.value.AutoValue;
import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.AutoValue_Config;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigValueParser;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigValueParsers;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.NamingConvention;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

@AutoValue
public abstract class Config {
    @Nullable
    private static volatile Config instance = null;

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    static Config create(Map<String, String> allProperties) {
        return new AutoValue_Config(allProperties);
    }

    Config() {
    }

    public static void internalInitializeConfig(Config config) {
        if (instance != null) {
            return;
        }
        instance = Objects.requireNonNull(config);
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.builder().readEnvironmentVariables().readSystemProperties().build();
        }
        return instance;
    }

    public abstract Map<String, String> getAllProperties();

    @Nullable
    public String getString(String name) {
        return this.getRawProperty(name, null);
    }

    public String getString(String name, String defaultValue) {
        return this.getRawProperty(name, defaultValue);
    }

    @Nullable
    public Boolean getBoolean(String name) {
        return this.getTypedProperty(name, ConfigValueParsers::parseBoolean);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseBoolean, defaultValue);
    }

    @Nullable
    public Integer getInt(String name) {
        return this.getTypedProperty(name, ConfigValueParsers::parseInt);
    }

    public int getInt(String name, int defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseInt, defaultValue);
    }

    @Nullable
    public Long getLong(String name) {
        return this.getTypedProperty(name, ConfigValueParsers::parseLong);
    }

    public long getLong(String name, long defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseLong, defaultValue);
    }

    @Nullable
    public Double getDouble(String name) {
        return this.getTypedProperty(name, ConfigValueParsers::parseDouble);
    }

    public double getDouble(String name, double defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseDouble, defaultValue);
    }

    @Nullable
    public Duration getDuration(String name) {
        return this.getTypedProperty(name, ConfigValueParsers::parseDuration);
    }

    public Duration getDuration(String name, Duration defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseDuration, defaultValue);
    }

    public List<String> getList(String name) {
        List list = this.getTypedProperty(name, ConfigValueParsers::parseList);
        return list == null ? Collections.emptyList() : list;
    }

    public List<String> getList(String name, List<String> defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseList, defaultValue);
    }

    public Map<String, String> getMap(String name) {
        Map map = this.getTypedProperty(name, ConfigValueParsers::parseMap);
        return map == null ? Collections.emptyMap() : map;
    }

    public Map<String, String> getMap(String name, Map<String, String> defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseMap, defaultValue);
    }

    private <T> T safeGetTypedProperty(String name, ConfigValueParser<T> parser, T defaultValue) {
        try {
            T value = this.getTypedProperty(name, parser);
            return value == null ? defaultValue : value;
        }
        catch (RuntimeException t) {
            return defaultValue;
        }
    }

    @Nullable
    private <T> T getTypedProperty(String name, ConfigValueParser<T> parser) {
        String value = this.getRawProperty(name, null);
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return parser.parse(name, value);
    }

    private String getRawProperty(String name, String defaultValue) {
        return this.getAllProperties().getOrDefault(NamingConvention.DOT.normalize(name), defaultValue);
    }

    public boolean isInstrumentationEnabled(Iterable<String> instrumentationNames, boolean defaultEnabled) {
        return this.isInstrumentationPropertyEnabled(instrumentationNames, "enabled", defaultEnabled);
    }

    public boolean isInstrumentationPropertyEnabled(Iterable<String> instrumentationNames, String suffix, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : instrumentationNames) {
            String propertyName = "otel.instrumentation." + name + '.' + suffix;
            boolean enabled = this.getBoolean(propertyName, defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= enabled;
                continue;
            }
            anyEnabled |= enabled;
        }
        return anyEnabled;
    }

    public boolean isAgentDebugEnabled() {
        return this.getBoolean("otel.javaagent.debug", false);
    }

    @Deprecated
    public Properties asJavaProperties() {
        Properties properties = new Properties();
        properties.putAll(this.getAllProperties());
        return properties;
    }

    public void updateProperty(String key, String value) {
        this.getAllProperties().put(key, value);
    }
}

