/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw;

import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.ApplicationInsightsEtwException;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.DllFileUtils;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.events.model.IpaEtwEventBase;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;

public class EtwProvider {
    private static final String LIB_FILENAME_32_BIT = "applicationinsights-java-etw-provider-x86.dll";
    private static final String LIB_FILENAME_64_BIT = "applicationinsights-java-etw-provider-x86-64.dll";
    private static final Logger LOGGER = LoggerFactory.getLogger(EtwProvider.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EtwProvider(String sdkVersion) {
        String osname = System.getProperty("os.name");
        if (osname != null && osname.startsWith("Windows")) {
            File dllPath = null;
            try {
                dllPath = EtwProvider.loadLibrary(sdkVersion);
                LOGGER.debug("EtwProvider initialized. Lib path={}", (Object)dllPath.getAbsolutePath());
                return;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    LOGGER.error("Error initializing EtwProvider", t);
                    if (dllPath == null) return;
                    dllPath.deleteOnExit();
                    return;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        } else {
            LoggerFactory.getLogger(EtwProvider.class).info("Non-Windows OS. Loading ETW library skipped.");
        }
    }

    private static File loadLibrary(String sdkVersion) throws IOException {
        String fileName = EtwProvider.getDllFilenameForArch();
        File targetDir = DllFileUtils.buildDllLocalPath(sdkVersion);
        File dllPath = new File(targetDir, fileName);
        if (!dllPath.exists()) {
            DllFileUtils.extractToLocalFolder(dllPath, fileName);
        }
        System.load(dllPath.getAbsolutePath());
        return dllPath;
    }

    static String getDllFilenameForArch() {
        String osarch = System.getProperty("os.arch");
        boolean is32bit = osarch == null ? false : osarch.equalsIgnoreCase("x86");
        return is32bit ? LIB_FILENAME_32_BIT : LIB_FILENAME_64_BIT;
    }

    private native void cppWriteEvent(IpaEtwEventBase var1) throws ApplicationInsightsEtwException;

    public void writeEvent(IpaEtwEventBase event) throws ApplicationInsightsEtwException {
        this.cppWriteEvent(event);
    }
}

