/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.diagnostics;

import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.CachedDiagnosticsValueFinder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SdkVersionFinder
extends CachedDiagnosticsValueFinder {
    private static volatile String value;

    @Override
    public String getName() {
        return "sdkVersion";
    }

    @Override
    protected String populateValue() {
        return value;
    }

    public static String getTheValue() {
        return value;
    }

    public static String initVersion(Path agentPath) {
        value = SdkVersionFinder.readVersion(agentPath);
        return value;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String readVersion(Path agentPath) {
        try (JarFile jarFile = new JarFile(agentPath.toFile(), false);){
            String string;
            block13: {
                JarEntry entry = jarFile.getJarEntry("ai.sdk-version.properties");
                InputStream in = jarFile.getInputStream(entry);
                try {
                    Properties props = new Properties();
                    props.load(in);
                    string = props.getProperty("version");
                    if (in == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "unknown";
        }
    }
}

