/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.diagnostics;

import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.CachedDiagnosticsValueFinder;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PidFinder
extends CachedDiagnosticsValueFinder {
    public static final String PROPERTY_NAME = "PID";

    @Override
    protected String populateValue() {
        String java9pid = PidFinder.getPidUsingProcessHandle();
        if (java9pid != null) {
            return java9pid;
        }
        return PidFinder.getPidUsingRuntimeBean();
    }

    private static @Nullable String getPidUsingRuntimeBean() {
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        if (rb == null) {
            return null;
        }
        String name = rb.getName();
        if (name == null) {
            return null;
        }
        String pid = name.split("@")[0];
        if (pid == null) {
            return null;
        }
        try {
            return String.valueOf(Integer.parseInt(pid));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private static @Nullable String getPidUsingProcessHandle() {
        try {
            Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
            Method currentProcessHandleMethod = processHandleClass.getMethod("current", new Class[0]);
            Object currentProcessHandle = currentProcessHandleMethod.invoke(null, new Object[0]);
            if (currentProcessHandle == null) {
                return null;
            }
            Method pidMethod = processHandleClass.getMethod("pid", new Class[0]);
            Object pid = pidMethod.invoke(currentProcessHandle, new Object[0]);
            if (pid == null) {
                return null;
            }
            return pid.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return PROPERTY_NAME;
    }
}

