/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics.ingestion.models;

import com.microsoft.appcenter.ingestion.models.LogWithProperties;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class EventLog
extends LogWithProperties {
    public static final String TYPE = "event";
    private UUID id;
    private String name;

    public String getType() {
        return TYPE;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void read(JSONObject object) throws JSONException {
        super.read(object);
        this.setId(UUID.fromString(object.getString("id")));
        this.setName(object.getString("name"));
    }

    public void write(JSONStringer writer) throws JSONException {
        super.write(writer);
        writer.key("id").value((Object)this.getId());
        writer.key("name").value((Object)this.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventLog eventLog = (EventLog)((Object)o);
        if (this.id != null ? !this.id.equals(eventLog.id) : eventLog.id != null) {
            return false;
        }
        return this.name != null ? this.name.equals(eventLog.name) : eventLog.name == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

