/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.text.TextUtils;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationServerProtocolException;
import com.microsoft.aad.adal.ChallengeResponseBuilder;
import com.microsoft.aad.adal.HttpAuthDialog;
import com.microsoft.aad.adal.UIEvent;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.java.util.JWSBuilder;
import com.microsoft.identity.common.logging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;

abstract class BasicWebViewClient
extends WebViewClient {
    private static final String INSTALL_URL_KEY = "app_link";
    private static final String TAG = "BasicWebViewClient";
    static final String BLANK_PAGE = "about:blank";
    final AuthenticationRequest mRequest;
    private String mRedirect;
    private final Context mCallingContext;
    private final UIEvent mUIEvent;

    BasicWebViewClient(@NonNull Context appContext, @NonNull String redirect, @NonNull AuthenticationRequest request, @Nullable UIEvent uiEvent) {
        this.mCallingContext = appContext;
        this.mRedirect = redirect;
        this.mRequest = request;
        this.mUIEvent = uiEvent;
    }

    public abstract void showSpinner(boolean var1);

    public abstract void sendResponse(int var1, Intent var2);

    public abstract void cancelWebViewRequest(@Nullable Intent var1);

    public abstract void prepareForBrokerResumeRequest();

    public abstract void setPKeyAuthStatus(boolean var1);

    public abstract void postRunnable(Runnable var1);

    public abstract void processRedirectUrl(WebView var1, String var2);

    public abstract boolean processInvalidUrl(WebView var1, String var2);

    public void onReceivedHttpAuthRequest(WebView view, final HttpAuthHandler handler, String host, String realm) {
        String methodName = ":onReceivedHttpAuthRequest";
        com.microsoft.identity.common.internal.logging.Logger.infoPII((String)"BasicWebViewClient:onReceivedHttpAuthRequest", (String)("Start. Host: " + host));
        if (this.mUIEvent != null) {
            this.mUIEvent.setNTLM(true);
        }
        HttpAuthDialog authDialog = new HttpAuthDialog(this.mCallingContext, host, realm);
        authDialog.setOkListener(new HttpAuthDialog.OkListener(){

            @Override
            public void onOk(String host, String realm, String username, String password) {
                com.microsoft.identity.common.internal.logging.Logger.infoPII((String)"BasicWebViewClient:onReceivedHttpAuthRequest", (String)("Handler proceed. Host: " + host));
                handler.proceed(username, password);
            }
        });
        authDialog.setCancelListener(new HttpAuthDialog.CancelListener(){

            @Override
            public void onCancel() {
                com.microsoft.identity.common.internal.logging.Logger.infoPII((String)"BasicWebViewClient:onReceivedHttpAuthRequest", (String)"Handler cancelled.");
                handler.cancel();
                BasicWebViewClient.this.cancelWebViewRequest(null);
            }
        });
        com.microsoft.identity.common.internal.logging.Logger.info((String)"BasicWebViewClient:onReceivedHttpAuthRequest", (String)"Show dialog.");
        authDialog.show();
    }

    public void onReceivedError(@NonNull WebView view, int errorCode, @NonNull String description, @NonNull String failingUrl) {
        this.sendErrorResponse(errorCode, description);
    }

    @RequiresApi(api=23)
    public void onReceivedError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceError error) {
        String methodName = "onReceivedError (23)";
        boolean isForMainFrame = request.isForMainFrame();
        Logger.warn((String)"BasicWebViewClientonReceivedError (23)", (String)("WebResourceError - isForMainFrame? " + isForMainFrame));
        Logger.warnPII((String)"BasicWebViewClientonReceivedError (23)", (String)("Failing url: " + request.getUrl()));
        if (isForMainFrame) {
            this.sendErrorResponse(error.getErrorCode(), error.getDescription().toString());
        }
    }

    private void sendErrorResponse(int errorCode, @NonNull String description) {
        this.showSpinner(false);
        com.microsoft.identity.common.internal.logging.Logger.errorPII((String)TAG, (String)("Webview received an error. ErrorCode: " + errorCode + " Error description: " + description), null);
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Error Code:" + errorCode);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", description);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mRequest);
        this.sendResponse(2002, resultIntent);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        super.onReceivedSslError(view, handler, error);
        this.showSpinner(false);
        handler.cancel();
        com.microsoft.identity.common.internal.logging.Logger.error((String)TAG, (String)"Received SSL error.", null);
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Code:-11");
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", error.toString());
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mRequest);
        this.sendResponse(2002, resultIntent);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        view.setVisibility(0);
        if (!url.startsWith(BLANK_PAGE)) {
            this.showSpinner(false);
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        this.logPageStartLoadingUrl(url);
        super.onPageStarted(view, url, favicon);
        this.showSpinner(true);
    }

    private void logPageStartLoadingUrl(String url) {
        String methodName = ":logPageStartLoadingUrl";
        if (TextUtils.isEmpty((CharSequence)url)) {
            com.microsoft.identity.common.internal.logging.Logger.warn((String)"BasicWebViewClient:logPageStartLoadingUrl", (String)"onPageStarted: Null url for page to load.");
            return;
        }
        Uri uri = Uri.parse((String)url);
        if (uri.isOpaque()) {
            com.microsoft.identity.common.internal.logging.Logger.warn((String)"BasicWebViewClient:logPageStartLoadingUrl", (String)"onPageStarted: Non-hierarchical loading uri.");
            com.microsoft.identity.common.internal.logging.Logger.warnPII((String)"BasicWebViewClient:logPageStartLoadingUrl", (String)("Url: " + url));
            return;
        }
        com.microsoft.identity.common.internal.logging.Logger.verbose((String)"BasicWebViewClient:logPageStartLoadingUrl", (String)"WebView starts loading.");
        com.microsoft.identity.common.internal.logging.Logger.verbosePII((String)"BasicWebViewClient:logPageStartLoadingUrl", (String)("Host: " + uri.getHost() + "\nPath: " + uri.getPath()));
        if (StringExtensions.isNullOrBlank((String)uri.getQueryParameter("code"))) {
            com.microsoft.identity.common.internal.logging.Logger.verbosePII((String)"BasicWebViewClient:logPageStartLoadingUrl", (String)("Url did not contain auth code.\nFull loading url is: " + url));
        } else {
            com.microsoft.identity.common.internal.logging.Logger.verbose((String)"BasicWebViewClient:logPageStartLoadingUrl", (String)"Auth code received.");
        }
    }

    public boolean shouldOverrideUrlLoading(final WebView view, final String url) {
        String methodName = ":shouldOverrideUrlLoading";
        com.microsoft.identity.common.internal.logging.Logger.verbose((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Navigation is detected.");
        if (url.startsWith("urn:http-auth:PKeyAuth")) {
            com.microsoft.identity.common.internal.logging.Logger.verbose((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Webview detected request for pkeyauth challenge.");
            view.stopLoading();
            this.setPKeyAuthStatus(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ChallengeResponseBuilder certHandler = new ChallengeResponseBuilder(new JWSBuilder());
                        final ChallengeResponseBuilder.ChallengeResponse challengeResponse = certHandler.getChallengeResponseFromUri(url);
                        final HashMap<String, String> headers = new HashMap<String, String>();
                        headers.put("Authorization", challengeResponse.getAuthorizationHeaderValue());
                        BasicWebViewClient.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                String loadUrl = challengeResponse.getSubmitUrl();
                                com.microsoft.identity.common.internal.logging.Logger.verbose((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Respond to pkeyAuth challenge.");
                                com.microsoft.identity.common.internal.logging.Logger.verbosePII((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)("Challenge submit url:" + challengeResponse.getSubmitUrl()));
                                view.loadUrl(loadUrl, headers);
                            }
                        });
                    }
                    catch (AuthenticationServerProtocolException e) {
                        com.microsoft.identity.common.internal.logging.Logger.errorPII((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Argument exception", (Throwable)e);
                        Intent resultIntent = new Intent();
                        resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)e);
                        if (BasicWebViewClient.this.mRequest != null) {
                            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)BasicWebViewClient.this.mRequest);
                        }
                        BasicWebViewClient.this.sendResponse(2005, resultIntent);
                    }
                    catch (AuthenticationException e) {
                        com.microsoft.identity.common.internal.logging.Logger.error((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Failed to create device certificate response", null);
                        com.microsoft.identity.common.internal.logging.Logger.errorPII((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Error", (Throwable)e);
                        Intent resultIntent = new Intent();
                        resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)e);
                        if (BasicWebViewClient.this.mRequest != null) {
                            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)BasicWebViewClient.this.mRequest);
                        }
                        BasicWebViewClient.this.sendResponse(2005, resultIntent);
                    }
                }
            }).start();
            return true;
        }
        if (url.toLowerCase(Locale.US).startsWith(this.mRedirect.toLowerCase(Locale.US))) {
            com.microsoft.identity.common.internal.logging.Logger.verbose((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Navigation starts with the redirect uri.");
            Intent errorIntent = this.parseError(url);
            if (errorIntent != null) {
                com.microsoft.identity.common.internal.logging.Logger.info((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Sending intent to cancel authentication activity");
                view.stopLoading();
                this.cancelWebViewRequest(errorIntent);
                return true;
            }
            this.processRedirectUrl(view, url);
            return true;
        }
        if (url.startsWith("browser://")) {
            com.microsoft.identity.common.internal.logging.Logger.verbose((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"It is an external website request");
            view.stopLoading();
            if (url.contains("&ismdmurl=1")) {
                com.microsoft.identity.common.internal.logging.Logger.warn((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Failed to launch Company Portal, falling back to browser.");
                this.openLinkInBrowser(url);
                this.sendResponse(2009, new Intent());
            } else {
                this.openLinkInBrowser(url);
                this.cancelWebViewRequest(null);
            }
            return true;
        }
        if (url.startsWith("msauth://")) {
            com.microsoft.identity.common.internal.logging.Logger.verbose((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"It is an install request");
            HashMap parameters = StringExtensions.getUrlParameters((String)url);
            this.prepareForBrokerResumeRequest();
            int threadSleepForCallingActivity = 1000;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                com.microsoft.identity.common.internal.logging.Logger.warn((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Error occurred when having thread sleeping for 1 second.");
            }
            this.openLinkInBrowser((String)parameters.get(INSTALL_URL_KEY));
            view.stopLoading();
            return true;
        }
        if (url.toLowerCase(Locale.US).startsWith("market://details?id=")) {
            view.stopLoading();
            if (!url.startsWith("market://details?id=com.microsoft.windowsintune.companyportal") && !url.startsWith("market://details?id=com.azure.authenticator")) {
                com.microsoft.identity.common.internal.logging.Logger.info((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"The URI is either trying to open an unknown application or contains unknown query parameters");
                return false;
            }
            String appPackageName = url.contains("com.microsoft.windowsintune.companyportal") ? "com.microsoft.windowsintune.companyportal" : "com.azure.authenticator";
            com.microsoft.identity.common.internal.logging.Logger.verbose((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)("Request to open PlayStore to install : '" + appPackageName + "'"));
            try {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + appPackageName)));
                intent.addFlags(0x10008000);
                this.mCallingContext.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                com.microsoft.identity.common.internal.logging.Logger.error((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Failed to launch the PlayStore.", (Throwable)e);
            }
            return true;
        }
        if (url.toLowerCase(Locale.US).startsWith("microsoft-authenticator://activatemfa")) {
            com.microsoft.identity.common.internal.logging.Logger.verbose((String)"BasicWebViewClient:shouldOverrideUrlLoading", (String)"Linking Account in Authenticator to complete MFA setup.");
            try {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                intent.addFlags(0x10000000);
                this.mCallingContext.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                com.microsoft.identity.common.internal.logging.Logger.error((String)TAG, (String)"Failed to open the Authenticator application.", (Throwable)e);
            }
            return true;
        }
        return this.processInvalidUrl(view, url);
    }

    final Context getCallingContext() {
        return this.mCallingContext;
    }

    protected void openLinkInBrowser(String url) {
        String link = url.replace("browser://", "https://");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
        this.mCallingContext.startActivity(intent);
    }

    private Intent parseError(String redirectUrl) {
        HashMap parameters = StringExtensions.getUrlParameters((String)redirectUrl);
        String error = (String)parameters.get("error");
        String errorDescription = (String)parameters.get("error_description");
        if (!StringExtensions.isNullOrBlank((String)error)) {
            com.microsoft.identity.common.internal.logging.Logger.warnPII((String)TAG, (String)("Cancel error: " + error + "\nError Description: " + errorDescription));
            Intent intent = new Intent();
            intent.putExtra("error", error);
            intent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", error);
            intent.putExtra("error_description", errorDescription);
            intent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", errorDescription);
            return intent;
        }
        return null;
    }
}

