/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.os.Build;
import android.os.Process;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.HttpWebRequest;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.Logger;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class WebRequestHandler
implements IWebRequestHandler {
    private static final String TAG = "WebRequestHandler";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_JSON = "application/json";
    private UUID mRequestCorrelationId = null;

    @Override
    public HttpWebResponse sendGet(URL url, Map<String, String> headers) throws IOException {
        Logger.v(TAG, "WebRequestHandler thread" + Process.myTid());
        HttpWebRequest request = new HttpWebRequest(url, "GET", this.updateHeaders(headers));
        return request.send();
    }

    @Override
    public HttpWebResponse sendPost(URL url, Map<String, String> headers, byte[] content, String contentType) throws IOException {
        Logger.v(TAG, "WebRequestHandler thread" + Process.myTid());
        HttpWebRequest request = new HttpWebRequest(url, "POST", this.updateHeaders(headers), content, contentType);
        return request.send();
    }

    private Map<String, String> updateHeaders(Map<String, String> headers) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        if (this.mRequestCorrelationId != null) {
            headers.put("client-request-id", this.mRequestCorrelationId.toString());
        }
        headers.put("x-client-SKU", "Android");
        headers.put("x-client-Ver", AuthenticationContext.getVersionName());
        headers.put("x-client-OS", "" + Build.VERSION.SDK_INT);
        headers.put("x-client-DM", Build.MODEL);
        return headers;
    }

    @Override
    public void setRequestCorrelationId(UUID requestCorrelationId) {
        this.mRequestCorrelationId = requestCorrelationId;
    }
}

