/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.intset;

import it.uniroma3.mat.extendedset.intset.AbstractIntSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import it.uniroma3.mat.extendedset.utilities.BitCount;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.Locale;
import java.util.NoSuchElementException;

public class FastSet
extends AbstractIntSet
implements Serializable {
    private static final long serialVersionUID = 6519808981110513440L;
    private static final int WORD_SIZE = 32;
    private static final int ALL_ONES_WORD = -1;
    private int[] words;
    private transient int firstEmptyWord;
    private transient int size;

    public FastSet() {
        this.clear();
    }

    private FastSet(int wordsToAllocate) {
        this.firstEmptyWord = 0;
        this.size = 0;
        this.words = new int[wordsToAllocate];
    }

    private static int multiplyByWordSize(int i) {
        return i << 5;
    }

    private static int wordIndex(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("index < 0: " + bitIndex);
        }
        return bitIndex >> 5;
    }

    private static int wordIndexNoCheck(int bitIndex) {
        return bitIndex >> 5;
    }

    private void fixFirstEmptyWord() {
        int i;
        int[] localWords = this.words;
        for (i = this.firstEmptyWord - 1; i >= 0 && localWords[i] == 0; --i) {
        }
        this.firstEmptyWord = i + 1;
    }

    private void ensureCapacity(int wordsRequired) {
        if (this.words.length >= wordsRequired) {
            return;
        }
        int newLength = Math.max(this.words.length << 1, wordsRequired);
        this.words = Arrays.copyOf(this.words, newLength);
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.firstEmptyWord < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.firstEmptyWord = wordsRequired;
        }
    }

    @Override
    public FastSet clone() {
        FastSet res = new FastSet();
        res.firstEmptyWord = this.firstEmptyWord;
        res.size = this.size;
        res.words = Arrays.copyOf(this.words, this.firstEmptyWord);
        return res;
    }

    @Override
    public int hashCode() {
        int h = 1;
        int[] localWords = this.words;
        for (int i = 0; i < this.firstEmptyWord; ++i) {
            h = (h << 5) - h + localWords[i];
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FastSet)) {
            return super.equals(obj);
        }
        FastSet other = (FastSet)obj;
        if (this.firstEmptyWord != other.firstEmptyWord) {
            return false;
        }
        int[] localWords = this.words;
        int[] localOtherWords = other.words;
        for (int i = 0; i < this.firstEmptyWord; ++i) {
            if (localWords[i] == localOtherWords[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.firstEmptyWord == 0;
    }

    @Override
    public int size() {
        if (this.size < 0) {
            this.size = BitCount.count(this.words, this.firstEmptyWord);
        }
        return this.size;
    }

    @Override
    public boolean add(int i) {
        int wordIndex = FastSet.wordIndex(i);
        this.expandTo(wordIndex);
        int before = this.words[wordIndex];
        int n = wordIndex;
        this.words[n] = this.words[n] | 1 << i;
        if (before != this.words[wordIndex]) {
            if (this.size >= 0) {
                ++this.size;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int i) {
        if (i < 0) {
            return false;
        }
        int wordIndex = FastSet.wordIndex(i);
        if (wordIndex >= this.firstEmptyWord) {
            return false;
        }
        int before = this.words[wordIndex];
        int n = wordIndex;
        this.words[n] = this.words[n] & ~(1 << i);
        if (before != this.words[wordIndex]) {
            if (this.size >= 0) {
                --this.size;
            }
            this.fixFirstEmptyWord();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(IntSet c) {
        if (c == null || c.isEmpty() || this == c) {
            return false;
        }
        FastSet other = this.convert(c);
        int wordsInCommon = Math.min(this.firstEmptyWord, other.firstEmptyWord);
        boolean modified = false;
        if (this.firstEmptyWord < other.firstEmptyWord) {
            modified = true;
            this.ensureCapacity(other.firstEmptyWord);
            this.firstEmptyWord = other.firstEmptyWord;
        }
        int[] localWords = this.words;
        int[] localOtherWords = other.words;
        for (int i = 0; i < wordsInCommon; ++i) {
            int before = localWords[i];
            int n = i;
            localWords[n] = localWords[n] | localOtherWords[i];
            modified = modified || before != localWords[i];
        }
        if (wordsInCommon < other.firstEmptyWord) {
            modified = true;
            System.arraycopy(other.words, wordsInCommon, this.words, wordsInCommon, this.firstEmptyWord - wordsInCommon);
        }
        if (modified) {
            this.size = -1;
        }
        return modified;
    }

    @Override
    public boolean removeAll(IntSet c) {
        if (c == null || c.isEmpty() || this.isEmpty()) {
            return false;
        }
        if (c == this) {
            this.clear();
            return true;
        }
        FastSet other = this.convert(c);
        int[] localWords = this.words;
        int[] localOtherWords = other.words;
        boolean modified = false;
        for (int i = Math.min(this.firstEmptyWord, other.firstEmptyWord) - 1; i >= 0; --i) {
            int before = localWords[i];
            int n = i;
            localWords[n] = localWords[n] & ~localOtherWords[i];
            modified = modified || before != localWords[i];
        }
        if (modified) {
            this.fixFirstEmptyWord();
            this.size = -1;
        }
        return modified;
    }

    @Override
    public boolean retainAll(IntSet c) {
        if (this.isEmpty() || c == this) {
            return false;
        }
        if (c == null || c.isEmpty()) {
            this.clear();
            return true;
        }
        FastSet other = this.convert(c);
        int[] localWords = this.words;
        int[] localOtherWords = other.words;
        boolean modified = false;
        if (this.firstEmptyWord > other.firstEmptyWord) {
            modified = true;
            while (this.firstEmptyWord > other.firstEmptyWord) {
                localWords[--this.firstEmptyWord] = 0;
            }
        }
        for (int i = 0; i < this.firstEmptyWord; ++i) {
            int before = localWords[i];
            int n = i;
            localWords[n] = localWords[n] & localOtherWords[i];
            modified = modified || before != localWords[i];
        }
        if (modified) {
            this.fixFirstEmptyWord();
            this.size = -1;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.words = new int[10];
        this.firstEmptyWord = 0;
        this.size = 0;
    }

    @Override
    public boolean contains(int i) {
        if (this.isEmpty() || i < 0) {
            return false;
        }
        int wordIndex = FastSet.wordIndexNoCheck(i);
        return wordIndex < this.firstEmptyWord && (this.words[wordIndex] & 1 << i) != 0;
    }

    @Override
    public boolean containsAll(IntSet c) {
        if (c == null || c.isEmpty() || c == this) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        FastSet other = this.convert(c);
        if (other.firstEmptyWord > this.firstEmptyWord) {
            return false;
        }
        int[] localWords = this.words;
        int[] localOtherWords = other.words;
        for (int i = 0; i < other.firstEmptyWord; ++i) {
            int o = localOtherWords[i];
            if ((localWords[i] & o) == o) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeast(IntSet c, int minElements) {
        if (minElements < 1) {
            throw new IllegalArgumentException();
        }
        if (this.size >= 0 && this.size < minElements || c == null || c.isEmpty() || this.isEmpty()) {
            return false;
        }
        if (this == c) {
            return this.size() >= minElements;
        }
        FastSet other = this.convert(c);
        int[] localWords = this.words;
        int[] localOtherWords = other.words;
        int count = 0;
        for (int i = Math.min(this.firstEmptyWord, other.firstEmptyWord) - 1; i >= 0; --i) {
            if ((count += BitCount.count(localWords[i] & localOtherWords[i])) < minElements) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAny(IntSet c) {
        if (c == null || c.isEmpty() || c == this) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        FastSet other = this.convert(c);
        int[] localWords = this.words;
        int[] localOtherWords = other.words;
        for (int i = Math.min(this.firstEmptyWord, other.firstEmptyWord) - 1; i >= 0; --i) {
            if ((localWords[i] & localOtherWords[i]) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int intersectionSize(IntSet c) {
        if (c == null || c.isEmpty()) {
            return 0;
        }
        if (c == this) {
            return this.size();
        }
        if (this.isEmpty()) {
            return 0;
        }
        FastSet other = this.convert(c);
        int[] localWords = this.words;
        int[] localOtherWords = other.words;
        int count = 0;
        for (int i = Math.min(this.firstEmptyWord, other.firstEmptyWord) - 1; i >= 0; --i) {
            count += BitCount.count(localWords[i] & localOtherWords[i]);
        }
        return count;
    }

    @Override
    public IntSet.IntIterator iterator() {
        return new BitIterator();
    }

    @Override
    public IntSet.IntIterator descendingIterator() {
        return new ReverseBitIterator();
    }

    @Override
    public int last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return FastSet.multiplyByWordSize(this.firstEmptyWord - 1) + (32 - Integer.numberOfLeadingZeros(this.words[this.firstEmptyWord - 1])) - 1;
    }

    @Override
    public void complement() {
        if (this.isEmpty()) {
            return;
        }
        if (this.size > 0) {
            this.size = this.last() - this.size + 1;
        }
        int lastWordMask = -1 >>> Integer.numberOfLeadingZeros(this.words[this.firstEmptyWord - 1]);
        int[] localWords = this.words;
        int i = 0;
        while (i < this.firstEmptyWord - 1) {
            int n = i++;
            localWords[n] = ~localWords[n];
        }
        int n = this.firstEmptyWord - 1;
        localWords[n] = localWords[n] ^ lastWordMask;
        this.fixFirstEmptyWord();
    }

    @Override
    public FastSet complemented() {
        FastSet clone = this.clone();
        clone.complement();
        return clone;
    }

    @Override
    public FastSet empty() {
        return new FastSet();
    }

    @Override
    public double bitmapCompressionRatio() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public double collectionCompressionRatio() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return (double)this.firstEmptyWord / (double)this.size();
    }

    private FastSet convert(IntSet c) {
        if (c instanceof FastSet) {
            return (FastSet)c;
        }
        if (c == null) {
            return new FastSet();
        }
        FastSet res = new FastSet();
        IntSet.IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            res.add(itr.next());
        }
        return res;
    }

    @Override
    public FastSet convert(Collection<Integer> c) {
        FastSet res = this.empty();
        if (c != null) {
            for (int i : c) {
                res.add(i);
            }
        }
        return res;
    }

    @Override
    public FastSet convert(int ... a) {
        FastSet res = new FastSet();
        if (a != null) {
            for (int i : a) {
                res.add(i);
            }
        }
        return res;
    }

    @Override
    public void fill(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        if (fromIndex == toIndex) {
            this.add(fromIndex);
            return;
        }
        int startWordIndex = FastSet.wordIndex(fromIndex);
        int endWordIndex = FastSet.wordIndex(toIndex);
        this.expandTo(endWordIndex);
        int[] localWords = this.words;
        boolean modified = false;
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -(toIndex + 1);
        if (startWordIndex == endWordIndex) {
            int before = localWords[startWordIndex];
            int n = startWordIndex;
            localWords[n] = localWords[n] | firstWordMask & lastWordMask;
            modified = localWords[startWordIndex] != before;
        } else {
            int before = localWords[startWordIndex];
            int n = startWordIndex;
            localWords[n] = localWords[n] | firstWordMask;
            modified = localWords[startWordIndex] != before;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                modified = modified || localWords[i] != -1;
                localWords[i] = -1;
            }
            before = localWords[endWordIndex];
            int n2 = endWordIndex;
            localWords[n2] = localWords[n2] | lastWordMask;
            boolean bl = modified = modified || localWords[endWordIndex] != before;
        }
        if (modified) {
            this.size = -1;
        }
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        if (fromIndex == toIndex) {
            this.remove(fromIndex);
            return;
        }
        int startWordIndex = FastSet.wordIndex(fromIndex);
        if (startWordIndex >= this.firstEmptyWord) {
            return;
        }
        int endWordIndex = FastSet.wordIndex(toIndex);
        if (endWordIndex >= this.firstEmptyWord) {
            toIndex = this.last();
            endWordIndex = this.firstEmptyWord - 1;
        }
        int[] localWords = this.words;
        boolean modified = false;
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -(toIndex + 1);
        if (startWordIndex == endWordIndex) {
            int before = localWords[startWordIndex];
            int n = startWordIndex;
            localWords[n] = localWords[n] & ~(firstWordMask & lastWordMask);
            modified = localWords[startWordIndex] != before;
        } else {
            int before = localWords[startWordIndex];
            int n = startWordIndex;
            localWords[n] = localWords[n] & ~firstWordMask;
            modified = localWords[startWordIndex] != before;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                modified = modified || localWords[i] != 0;
                localWords[i] = 0;
            }
            before = localWords[endWordIndex];
            int n2 = endWordIndex;
            localWords[n2] = localWords[n2] & ~lastWordMask;
            boolean bl = modified = modified || localWords[endWordIndex] != before;
        }
        if (modified) {
            this.fixFirstEmptyWord();
            this.size = -1;
        }
    }

    @Override
    public void flip(int e) {
        int wordIndex = FastSet.wordIndex(e);
        this.expandTo(wordIndex);
        int mask = 1 << e;
        int n = wordIndex;
        this.words[n] = this.words[n] ^ mask;
        this.fixFirstEmptyWord();
        if (this.size >= 0) {
            this.size = (this.words[wordIndex] & mask) == 0 ? --this.size : ++this.size;
        }
    }

    @Override
    public int compareTo(IntSet o) {
        if (this.isEmpty() && o.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (o.isEmpty()) {
            return 1;
        }
        FastSet other = this.convert(o);
        int[] localWords = this.words;
        int[] localOtherWords = other.words;
        if (this.firstEmptyWord > other.firstEmptyWord) {
            return 1;
        }
        if (this.firstEmptyWord < other.firstEmptyWord) {
            return -1;
        }
        for (int i = this.firstEmptyWord - 1; i >= 0; --i) {
            int res;
            long w1 = (long)localWords[i] & 0xFFFFFFFFL;
            long w2 = (long)localOtherWords[i] & 0xFFFFFFFFL;
            int n = w1 < w2 ? -1 : (res = w1 > w2 ? 1 : 0);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    @Override
    public int get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        int[] localWords = this.words;
        for (int j = 0; j < this.firstEmptyWord; ++j) {
            int w = localWords[j];
            int current = BitCount.count(w);
            if (index < count + current) {
                int bit = -1;
                for (int skip = index - count; skip >= 0; --skip) {
                    bit = Integer.numberOfTrailingZeros(w & -1 << bit + 1);
                }
                return FastSet.multiplyByWordSize(j) + bit;
            }
            count += current;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int indexOf(int e) {
        if (e < 0) {
            throw new IllegalArgumentException("positive integer expected: " + Integer.toString(e));
        }
        if (this.isEmpty()) {
            return -1;
        }
        int index = FastSet.wordIndex(e);
        if (index >= this.firstEmptyWord || (this.words[index] & 1 << e) == 0) {
            return -1;
        }
        int count = BitCount.count(this.words, index);
        return count += BitCount.count(this.words[index] & ~(-1 << e));
    }

    @Override
    public FastSet intersection(IntSet other) {
        if (this.isEmpty() || other == null || other.isEmpty()) {
            return this.empty();
        }
        if (other == this) {
            return this.clone();
        }
        FastSet o = this.convert(other);
        FastSet res = new FastSet(Math.min(this.firstEmptyWord, o.firstEmptyWord));
        res.firstEmptyWord = res.words.length;
        int[] localWords = this.words;
        int[] localOtherWords = o.words;
        int[] localResWords = res.words;
        for (int i = 0; i < res.firstEmptyWord; ++i) {
            localResWords[i] = localWords[i] & localOtherWords[i];
        }
        res.fixFirstEmptyWord();
        res.size = -1;
        return res;
    }

    @Override
    public FastSet union(IntSet other) {
        if (other == null || other.isEmpty() || this == other) {
            return this.clone();
        }
        FastSet o = this.convert(other);
        if (this.isEmpty()) {
            return o.clone();
        }
        FastSet res = new FastSet(Math.max(this.firstEmptyWord, o.firstEmptyWord));
        res.firstEmptyWord = res.words.length;
        int wordsInCommon = Math.min(this.firstEmptyWord, o.firstEmptyWord);
        int[] localWords = this.words;
        int[] localOtherWords = o.words;
        int[] localResWords = res.words;
        for (int i = 0; i < wordsInCommon; ++i) {
            localResWords[i] = localWords[i] | localOtherWords[i];
        }
        if (wordsInCommon < this.firstEmptyWord) {
            System.arraycopy(localWords, wordsInCommon, localResWords, wordsInCommon, res.firstEmptyWord - wordsInCommon);
        }
        if (wordsInCommon < o.firstEmptyWord) {
            System.arraycopy(localOtherWords, wordsInCommon, localResWords, wordsInCommon, res.firstEmptyWord - wordsInCommon);
        }
        res.size = -1;
        return res;
    }

    @Override
    public FastSet difference(IntSet other) {
        int i;
        if (other == null || other.isEmpty()) {
            return this.clone();
        }
        if (other == this || this.isEmpty()) {
            return this.empty();
        }
        FastSet o = this.convert(other);
        FastSet res = new FastSet(this.firstEmptyWord);
        res.firstEmptyWord = this.firstEmptyWord;
        int[] localWords = this.words;
        int[] localOtherWords = o.words;
        int[] localResWords = res.words;
        int m = Math.min(this.firstEmptyWord, o.firstEmptyWord);
        for (i = 0; i < m; ++i) {
            localResWords[i] = localWords[i] & ~localOtherWords[i];
        }
        if (i < this.firstEmptyWord) {
            System.arraycopy(localWords, i, localResWords, i, this.firstEmptyWord - i);
        } else {
            res.fixFirstEmptyWord();
        }
        res.size = -1;
        return res;
    }

    @Override
    public FastSet symmetricDifference(IntSet other) {
        if (other == null || other.isEmpty()) {
            return this.clone();
        }
        if (other == this) {
            return this.empty();
        }
        FastSet o = this.convert(other);
        if (this.isEmpty()) {
            return o.clone();
        }
        FastSet res = new FastSet(Math.max(this.firstEmptyWord, o.firstEmptyWord));
        res.firstEmptyWord = res.words.length;
        int wordsInCommon = Math.min(this.firstEmptyWord, o.firstEmptyWord);
        int[] localWords = this.words;
        int[] localOtherWords = o.words;
        int[] localResWords = res.words;
        for (int i = 0; i < wordsInCommon; ++i) {
            localResWords[i] = localWords[i] ^ localOtherWords[i];
        }
        if (wordsInCommon < this.firstEmptyWord) {
            System.arraycopy(localWords, wordsInCommon, localResWords, wordsInCommon, res.firstEmptyWord - wordsInCommon);
        } else if (wordsInCommon < o.firstEmptyWord) {
            System.arraycopy(localOtherWords, wordsInCommon, localResWords, wordsInCommon, res.firstEmptyWord - wordsInCommon);
        } else {
            res.fixFirstEmptyWord();
        }
        res.size = -1;
        return res;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        assert (this.words != null);
        if (this.firstEmptyWord < this.words.length) {
            this.words = Arrays.copyOf(this.words, this.firstEmptyWord);
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.firstEmptyWord = this.words.length;
        this.size = -1;
    }

    private static String toBinaryString(int word) {
        String lsb = Integer.toBinaryString(word);
        StringBuilder pad = new StringBuilder();
        for (int i = lsb.length(); i < 32; ++i) {
            pad.append('0');
        }
        return pad.append(lsb).toString();
    }

    @Override
    public String debugInfo() {
        StringBuilder s = new StringBuilder("INTERNAL REPRESENTATION:\n");
        Formatter f = new Formatter(s, Locale.ENGLISH);
        if (this.isEmpty()) {
            return s.append("null\n").toString();
        }
        f.format("Elements: %s\n", this.toString());
        for (int i = 0; i < this.firstEmptyWord; ++i) {
            f.format("words[%d] = %s (from %d to %d)\n", i, FastSet.toBinaryString(this.words[i]), FastSet.multiplyByWordSize(i), FastSet.multiplyByWordSize(i + 1) - 1);
        }
        f.format("wordsInUse: %d\n", this.firstEmptyWord);
        f.format("size: %s\n", this.size == -1 ? "invalid" : Integer.toString(this.size));
        f.format("words.length: %d\n", this.words.length);
        f.format("bitmap compression: %.2f%%\n", 100.0 * this.bitmapCompressionRatio());
        f.format("collection compression: %.2f%%\n", 100.0 * this.collectionCompressionRatio());
        return s.toString();
    }

    private class ReverseBitIterator
    implements IntSet.IntIterator {
        private int nextIndex;
        private int nextBit;
        private int last;

        private ReverseBitIterator() {
            this.nextIndex = FastSet.this.firstEmptyWord - 1;
            if (FastSet.this.isEmpty()) {
                return;
            }
            this.last = Integer.MAX_VALUE;
            this.nextBit = 32 - Integer.numberOfLeadingZeros(FastSet.this.words[this.nextIndex]) - 1;
        }

        void prepareNext() {
            int w = FastSet.this.words[this.nextIndex];
            while (--this.nextBit >= 0) {
                if ((w & 1 << this.nextBit) == 0) continue;
                return;
            }
            do {
                if (--this.nextIndex != -1) continue;
                return;
            } while ((w = FastSet.this.words[this.nextIndex]) == 0);
            this.nextBit = 32 - Integer.numberOfLeadingZeros(w) - 1;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = FastSet.multiplyByWordSize(this.nextIndex) + this.nextBit;
            this.prepareNext();
            return this.last;
        }

        @Override
        public void skipAllBefore(int element) {
            if (element < 0) {
                this.nextIndex = -1;
                return;
            }
            if (element >= this.last) {
                return;
            }
            int newNextIndex = FastSet.wordIndexNoCheck(element);
            int newNextBit = element & 0x1F;
            if (newNextIndex > this.nextIndex || newNextIndex == this.nextIndex && newNextBit >= this.nextBit) {
                return;
            }
            this.nextIndex = newNextIndex;
            this.nextBit = newNextBit;
            if ((FastSet.this.words[this.nextIndex] & 1 << this.nextBit) == 0) {
                this.prepareNext();
            }
        }

        @Override
        public void remove() {
            FastSet.this.remove(this.last);
        }

        @Override
        public IntSet.IntIterator clone() {
            BitIterator retVal = new BitIterator();
            retVal.nextIndex = this.nextIndex;
            retVal.nextBit = this.nextBit;
            retVal.last = this.last;
            return retVal;
        }
    }

    private class BitIterator
    implements IntSet.IntIterator {
        private int nextIndex = 0;
        private int nextBit;
        private int last;

        private BitIterator() {
            if (FastSet.this.isEmpty()) {
                return;
            }
            this.last = -1;
            while (FastSet.this.words[this.nextIndex] == 0) {
                ++this.nextIndex;
            }
            this.nextBit = Integer.numberOfTrailingZeros(FastSet.this.words[this.nextIndex]);
        }

        void prepareNext() {
            int w = FastSet.this.words[this.nextIndex];
            while (++this.nextBit < 32) {
                if ((w & 1 << this.nextBit) == 0) continue;
                return;
            }
            do {
                if (++this.nextIndex != FastSet.this.firstEmptyWord) continue;
                return;
            } while ((w = FastSet.this.words[this.nextIndex]) == 0);
            this.nextBit = Integer.numberOfTrailingZeros(w);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < FastSet.this.firstEmptyWord;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = FastSet.multiplyByWordSize(this.nextIndex) + this.nextBit;
            this.prepareNext();
            return this.last;
        }

        @Override
        public void skipAllBefore(int element) {
            if (element <= 0 || element <= this.last) {
                return;
            }
            int newNextIndex = FastSet.wordIndexNoCheck(element);
            int newNextBit = element & 0x1F;
            if (newNextIndex < this.nextIndex || newNextIndex == this.nextIndex && newNextBit <= this.nextBit) {
                return;
            }
            this.nextIndex = newNextIndex;
            if (this.nextIndex >= FastSet.this.firstEmptyWord) {
                return;
            }
            this.nextBit = newNextBit;
            if ((FastSet.this.words[this.nextIndex] & 1 << this.nextBit) == 0) {
                this.prepareNext();
            }
        }

        @Override
        public void remove() {
            FastSet.this.remove(this.last);
        }

        @Override
        public IntSet.IntIterator clone() {
            BitIterator retVal = new BitIterator();
            retVal.nextIndex = this.nextIndex;
            retVal.nextBit = this.nextBit;
            retVal.last = this.last;
            return retVal;
        }
    }
}

