/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird.objects.integrations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public enum HSMComponentType {
    BODY("BODY"),
    HEADER("HEADER"),
    FOOTER("FOOTER"),
    BUTTONS("BUTTONS"),
    CAROUSEL("CAROUSEL"),
    LIMITED_TIME_OFFER("LIMITED_TIME_OFFER");

    private static final Map<String, HSMComponentType> TYPE_MAP;
    private final String type;

    private HSMComponentType(String type) {
        this.type = type;
    }

    @JsonCreator
    public static HSMComponentType forValue(String value) {
        Objects.requireNonNull(value, "Value cannot be null");
        return TYPE_MAP.get(value.toLowerCase(Locale.ROOT));
    }

    @JsonValue
    public String toJson() {
        return this.getType();
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.getType();
    }

    static {
        HashMap<String, HSMComponentType> map = new HashMap<String, HSMComponentType>();
        for (HSMComponentType hsmComponentType : HSMComponentType.values()) {
            map.put(hsmComponentType.getType().toLowerCase(), hsmComponentType);
        }
        TYPE_MAP = Collections.unmodifiableMap(map);
    }
}

