/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.messagebird.exceptions.RequestValidationException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;

public class RequestValidator {
    public static final String SIGNATURE_HEADER = "MessageBird-Signature-JWT";
    private static final String ALGORITHM_SHA256 = "SHA-256";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final Algorithm HMAC256;
    private final Algorithm HMAC384;
    private final Algorithm HMAC512;
    private final boolean skipURLValidation;

    public RequestValidator(String signatureKey) {
        this(signatureKey, false);
    }

    public RequestValidator(String signatureKey, boolean skipURLValidation) {
        this.HMAC256 = Algorithm.HMAC256((String)signatureKey);
        this.HMAC384 = Algorithm.HMAC384((String)signatureKey);
        this.HMAC512 = Algorithm.HMAC512((String)signatureKey);
        this.skipURLValidation = skipURLValidation;
    }

    public DecodedJWT validateSignature(Clock clock, String signature, String url, byte[] requestBody) throws RequestValidationException {
        Claim payloadHashClaim;
        boolean payloadHashClaimExist;
        Algorithm algorithm;
        if (signature == null || signature.length() == 0) {
            throw new RequestValidationException("The signature can not be empty.");
        }
        if (!(this.skipURLValidation || url != null && url.length() != 0)) {
            throw new RequestValidationException("The url can not be empty.");
        }
        DecodedJWT jwt = JWT.decode((String)signature);
        switch (jwt.getAlgorithm()) {
            case "HS256": {
                algorithm = this.HMAC256;
                break;
            }
            case "HS384": {
                algorithm = this.HMAC384;
                break;
            }
            case "HS512": {
                algorithm = this.HMAC512;
                break;
            }
            default: {
                throw new RequestValidationException(String.format("The signing method '%s' is invalid.", jwt.getAlgorithm()));
            }
        }
        JWTVerifier.BaseVerification builder = (JWTVerifier.BaseVerification)JWT.require((Algorithm)algorithm).withIssuer("MessageBird").ignoreIssuedAt().acceptLeeway(1L);
        if (!this.skipURLValidation) {
            builder.withClaim("url_hash", RequestValidator.calculateSha256(url.getBytes()));
        }
        boolean bl = payloadHashClaimExist = !(payloadHashClaim = jwt.getClaim("payload_hash")).isNull() && !payloadHashClaim.isMissing();
        if (requestBody != null && requestBody.length > 0) {
            if (!payloadHashClaimExist) {
                throw new RequestValidationException("The Claim 'payload_hash' is not set but payload is present.");
            }
            builder.withClaim("payload_hash", RequestValidator.calculateSha256(requestBody));
        } else if (payloadHashClaimExist) {
            throw new RequestValidationException("The Claim 'payload_hash' is set but actual payload is missing.");
        }
        JWTVerifier verifier = clock == null ? builder.build() : builder.build(clock);
        try {
            return verifier.verify(jwt);
        }
        catch (SignatureVerificationException e) {
            throw new RequestValidationException("Signature is invalid.", e);
        }
        catch (JWTVerificationException e) {
            throw new RequestValidationException(e.getMessage(), e.getCause());
        }
    }

    public DecodedJWT validateSignature(String signature, String url, byte[] requestBody) throws RequestValidationException {
        return this.validateSignature(null, signature, url, requestBody);
    }

    public DecodedJWT validateSignature(String signature, byte[] requestBody) throws RequestValidationException {
        return this.validateSignature(null, signature, null, requestBody);
    }

    private static String calculateSha256(byte[] bytes) {
        try {
            return RequestValidator.encodeHex(MessageDigest.getInstance(ALGORITHM_SHA256).digest(bytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RequestValidationException(e);
        }
    }

    private static String encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = HEX_DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = HEX_DIGITS[0xF & data[i]];
        }
        return new String(out);
    }
}

